/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolImportPageOne;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolImportWizard;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolSelectionPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatapoolImportPageTwo
extends DatapoolSelectionPage {
    private Button useExistingDatapoolButton = null;
    private Button replaceExistingRecordsButton = null;

    public DatapoolImportPageTwo(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.getSelectedDatapool() != null) {
                if (this.isSelectedDatapoolEncrypted()) {
                    this.encryptedDatapoolPasswordText.setFocus();
                } else {
                    this.datapoolSelectionViewer.getViewer().getTree().setFocus();
                }
            } else {
                this.useExistingDatapoolButton.setFocus();
            }
        }
    }

    public void createControl(Composite parent) {
        Composite pane = new Composite(parent, 32);
        pane.setLayout((Layout)new GridLayout());
        pane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.useExistingDatapoolButton = new Button(pane, 32);
        this.useExistingDatapoolButton.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_useExistingButton);
        final Group exisitingDatapoolGroup = new Group(pane, 16);
        exisitingDatapoolGroup.setLayout((Layout)new GridLayout());
        exisitingDatapoolGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        exisitingDatapoolGroup.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_datapoolsGroup);
        super.createControl((Composite)exisitingDatapoolGroup);
        final Group existingRecordsGroup = new Group(pane, 16);
        existingRecordsGroup.setLayout((Layout)new GridLayout());
        existingRecordsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        existingRecordsGroup.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_recordsGroup);
        this.useExistingDatapoolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isEnabled = DatapoolImportPageTwo.this.useExistingDatapoolButton.getSelection();
                TestUIUtilities.setEnabled((Composite)existingRecordsGroup, isEnabled);
                TestUIUtilities.setEnabled((Composite)exisitingDatapoolGroup, isEnabled);
                if (isEnabled && DatapoolImportPageTwo.this.getSelectedDatapool() != null) {
                    if (DatapoolImportPageTwo.this.isSelectedDatapoolEncrypted()) {
                        DatapoolImportPageTwo.this.encryptedDatapoolPasswordText.setFocus();
                    } else {
                        DatapoolImportPageTwo.this.datapoolSelectionViewer.getViewer().getTree().setFocus();
                    }
                }
                DatapoolImportPageTwo.this.setPageComplete(DatapoolImportPageTwo.this.validatePage());
            }
        });
        Button appendToExistingRecordsButton = new Button((Composite)existingRecordsGroup, 16);
        appendToExistingRecordsButton.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_appendToExistingButton);
        appendToExistingRecordsButton.setSelection(true);
        appendToExistingRecordsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatapoolImportPageTwo.this.setPageComplete(DatapoolImportPageTwo.this.validatePage());
            }
        });
        this.replaceExistingRecordsButton = new Button((Composite)existingRecordsGroup, 16);
        this.replaceExistingRecordsButton.setText(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_replaceExistingButton);
        this.replaceExistingRecordsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatapoolImportPageTwo.this.setPageComplete(DatapoolImportPageTwo.this.validatePage());
            }
        });
        TestUIUtilities.setEnabled((Composite)existingRecordsGroup, false);
        TestUIUtilities.setEnabled((Composite)exisitingDatapoolGroup, false);
        pane.layout(false, true);
        this.setControl((Control)pane);
    }

    public IDatapool getSelectedDatapool() {
        if (this.useExistingDatapoolButton.getSelection()) {
            return super.getSelectedDatapool();
        }
        return null;
    }

    public boolean isReplaceExistingRecords() {
        if (this.useExistingDatapoolButton.getSelection()) {
            return this.replaceExistingRecordsButton.getSelection();
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return !this.useExistingDatapoolButton.getSelection();
    }

    protected boolean validatePage() {
        boolean isValid = false;
        if (this.useExistingDatapoolButton.getSelection()) {
            IDatapool selectedDatapool;
            if (super.validatePage() && (selectedDatapool = this.getSelectedDatapool()) != null) {
                Shell shell = this.getShell();
                shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
                try {
                    try {
                        DatapoolImportPageOne datapoolImportPage = ((DatapoolImportWizard)this.getWizard()).getDatapoolImportPageOne();
                        if (CSVImportExportUtil.getInstance().validateCSVFileWithDatapool(datapoolImportPage.getCSVFilePath(), selectedDatapool, datapoolImportPage.getCSVFileFirstRowContainsVariableNames(), datapoolImportPage.getCSVFileFirstColumnContainsEquivalenceClassNames(), this.isReplaceExistingRecords(), datapoolImportPage.getCSVFileEncoding())) {
                            isValid = true;
                            this.setErrorMessage(null);
                        }
                        this.setErrorMessage(UiPluginResourceBundle.DatapoolImportWizard_diffVariableInfoWarning);
                    }
                    catch (CorruptCSVFileException c) {
                        this.setErrorMessage(c.getMessage());
                        shell.setCursor(null);
                    }
                }
                finally {
                    shell.setCursor(null);
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        return isValid;
    }
}

