/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LocationHostNameWizardPage
extends WizardPage {
    private Text hostname;

    public LocationHostNameWizardPage() {
        super("locationHostNameWizardPage");
        this.setTitle(UiPluginResourceBundle.LocationHostNameWizardPage_TitlePage);
        this.setDescription(UiPluginResourceBundle.LocationHostNameWizardPage_DescPage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(UiPlugin.getID()) + ".locw0001");
        Label hostLabel = new Label(composite, 0);
        hostLabel.setText(UiPluginResourceBundle.LBL_HOST_NME);
        this.hostname = new Text(composite, 2048);
        this.hostname.setLayoutData((Object)new GridData(4, 1, true, false));
        this.hostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocationHostNameWizardPage.this.validatePage();
            }
        });
        Link testConnectionLink = new Link(composite, 0);
        testConnectionLink.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        testConnectionLink.setText("<a>" + UiPluginResourceBundle.TEST_CONNECTION_NAME + "</a>");
        testConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestUIUtilities.testConnection(LocationHostNameWizardPage.this.hostname.getText());
            }
        });
        this.initControl();
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.hostname.setFocus();
        }
    }

    public String getHostname() {
        if (this.hostname != null) {
            return this.hostname.getText();
        }
        return UiPlugin.getInstance().getRAServerHost();
    }

    protected void initControl() {
        this.hostname.setText(UiPlugin.getInstance().getRAServerHost());
    }

    protected void validatePage() {
        if ("".equals(this.hostname.getText().trim())) {
            this.setErrorMessage(UiPluginResourceBundle.LocationHostNameWizardPage_ERROR_HostNameEmpty);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

