/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ReportExtensionsWizard
extends ReportGeneratorWizard {
    private TestLocationPage testLocationPage = null;
    private IReportGenerator generator = null;

    public ReportExtensionsWizard(IReportGenerator generator) {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("report_wiz.gif"));
        this.generator = generator;
    }

    protected void initPages() {
        this.testLocationPage = new TestLocationPage("location", this.adjustLocation());
        this.testLocationPage.setTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL);
        this.testLocationPage.setDescription(UiPluginResourceBundle.WIZ_TST_REP_PG_LOC_DSC);
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            this.testLocationPage.setFileExtension(fileExtension);
            this.testLocationPage.setFileName("*." + fileExtension);
        }
    }

    protected String getFileExtension() {
        return null;
    }

    protected IStructuredSelection adjustLocation() {
        IResource res;
        IContainer parent;
        IStructuredSelection structuredSelection = this.getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource && (parent = (res = (IResource)selection).getParent()) != null && parent.exists()) {
            structuredSelection = new StructuredSelection((Object)parent);
        }
        return structuredSelection;
    }

    protected void addReportPages() throws Exception {
        this.addPage((IWizardPage)this.testLocationPage);
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        IFile file = null;
        IPath path = this.testLocationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        String fileExtension = "report";
        if (this.generator != null && this.generator.getReportFileExtension((ISelection)this.getSelection()) != null) {
            fileExtension = this.generator.getReportFileExtension((ISelection)this.getSelection());
        }
        if ((file = res.getFile(path = new Path(String.valueOf(this.testLocationPage.getFileName()) + "." + fileExtension))) == null) {
            throw new Exception("Exception caught when retrieving the file");
        }
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UiPluginResourceBundle.W_QUESTION, (String)UiPluginResourceBundle.FILE_EXISTS)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            if (this.generator != null) {
                inputStream = this.generator.generate(file, (ISelection)this.getSelection());
            }
        }
        catch (Exception e) {
            UiPlugin.logError(e);
            String error = e.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = e.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)NLS.bind((String)UiPluginResourceBundle.GENERATE_ERROR_, (Object)error));
            return null;
        }
        if (inputStream == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)UiPluginResourceBundle.REPORT_NO_CONTENT_ERROR_);
            return null;
        }
        try {
            if (file.exists()) {
                file.delete(true, true, null);
            }
            file.create(inputStream, true, null);
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
            UIUtil.openSaveFileErrorDialog((Shell)this.getShell(), (String)file.getFullPath().toString(), (Throwable)e);
            return null;
        }
        return file;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        UiPlugin.logError(e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        UiPlugin.logError(e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            UiPlugin.logError(exc);
            exc.printStackTrace();
        }
        return container;
    }

    public boolean isAvailable(ISelection selection) {
        return true;
    }
}

