/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeSelectionDialog;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TestLogImportWizardPage
extends TestLocationPage {
    protected FileFieldEditor editor;
    protected Button btnDatabase;
    protected Button btnTestSuite;
    protected IFile testSuite;
    protected Text testSuiteText;
    protected Label testSuiteLabel;

    public TestLogImportWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(pageName);
        this.setDescription(UiPluginResourceBundle.TestLogImportWizardPage_PAGE_DESCRIPTION);
    }

    protected void createAdvancedControls(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        GridData fileSelectionData = new GridData(768);
        fileSelectionArea.setLayoutData((Object)fileSelectionData);
        GridLayout fileSelectionLayout = new GridLayout();
        fileSelectionLayout.numColumns = 3;
        fileSelectionLayout.makeColumnsEqualWidth = false;
        fileSelectionLayout.marginWidth = 0;
        fileSelectionLayout.marginHeight = 0;
        fileSelectionArea.setLayout((Layout)fileSelectionLayout);
        this.editor = new FileFieldEditor("testLogImportFile", UiPluginResourceBundle.TestLogImportWizardPage_SELECT_SOURCE_FILE, fileSelectionArea);
        this.editor.getTextControl(fileSelectionArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fileName = new Path(TestLogImportWizardPage.this.editor.getStringValue()).lastSegment();
                if (fileName != null) {
                    TestLogImportWizardPage.this.setFileName(fileName);
                } else {
                    TestLogImportWizardPage.this.setFileName("");
                }
            }
        });
        String[] extensions = new String[]{"*.testlog"};
        this.editor.setFileExtensions(extensions);
        this.editor.getTextControl(fileSelectionArea).addListener(24, (Listener)this);
        this.testSuiteLabel = new Label(fileSelectionArea, 16384);
        this.testSuiteLabel.setFont(parent.getFont());
        this.testSuiteLabel.setText(UiPluginResourceBundle.TestLogImportWizardPage_SELECT_TEST_SUITE);
        this.testSuiteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TestLogImportWizardPage.this.testSuiteLabel = null;
            }
        });
        this.testSuiteText = new Text(fileSelectionArea, 2048);
        this.testSuiteText.setLayoutData((Object)new GridData(768));
        this.testSuiteText.setEditable(false);
        this.testSuiteText.addListener(24, (Listener)this);
        this.btnTestSuite = new Button(fileSelectionArea, 8);
        this.btnTestSuite.setFont(parent.getFont());
        this.btnTestSuite.setText(UiPluginResourceBundle.TestLogImportWizardPage_BROWSE);
        this.btnTestSuite.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                IProxyNode[] selectedProxyNodes;
                ProxyNodeSelectionDialog proxyNodeSelectionDialog = new ProxyNodeSelectionDialog(Display.getCurrent().getActiveShell(), UiPluginResourceBundle.DLG_RESOURCE_SEL, new String[]{"testsuite"}, 16);
                if (proxyNodeSelectionDialog.open() == 0 && (selectedProxyNodes = proxyNodeSelectionDialog.getSelectedProxyNodes()).length > 0 && (resource = selectedProxyNodes[0].getUnderlyingResource()) instanceof IFile) {
                    TestLogImportWizardPage.this.testSuite = (IFile)resource;
                    TestLogImportWizardPage.this.testSuiteText.setText(TestLogImportWizardPage.this.testSuite.getFullPath().toString());
                    TestLogImportWizardPage.this.setPageComplete(TestLogImportWizardPage.this.validatePage());
                }
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.btnTestSuite.setLayoutData((Object)gd);
        if (ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() != 0) {
            this.btnDatabase = new Button(fileSelectionArea, 32);
            this.btnDatabase.setText(UiPluginResourceBundle.TestLogImportWizardPage_IMPORT_INTO_DATABASE);
            this.btnDatabase.setSelection(false);
        }
        fileSelectionArea.moveAbove(null);
    }

    protected File getFragmentFile() {
        return new File(this.editor.getStringValue());
    }

    protected boolean isDatabase() {
        if (ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() != 0) {
            return this.btnDatabase.getSelection();
        }
        return false;
    }

    public void setFileName(String value) {
        int offset = value.lastIndexOf(46);
        if (offset > 0) {
            value = value.substring(0, offset);
        }
        super.setFileName(value);
    }

    protected IFile getTestSuite() {
        return this.testSuite;
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (valid) {
            File frag = this.getFragmentFile();
            IPath path = this.getContainerFullPath();
            valid = this.testSuite != null && frag != null && frag.exists() && path != null;
        }
        return valid;
    }
}

