/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveModelChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer2;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIStatus;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class CMNNamedElementProxyNode
extends EObjectProxyNode
implements IProxyNodeRenamer2,
IProxyNodeRenamer {
    private static final String TAG_NAME = "name";
    private static final String TAG_DESCRIPTION = "description";
    private String name;
    private String description;

    public CMNNamedElementProxyNode(String name, String description, URI uri, Object parent) {
        super(uri, parent);
        this.name = name;
        this.description = description;
    }

    public CMNNamedElementProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
        this.name = memento.getString(TAG_NAME);
        if (this.name == null) {
            throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve name field");
        }
        this.description = memento.getString(TAG_DESCRIPTION);
    }

    public CMNNamedElementProxyNode(EObject eObject, Object parent) {
        super(eObject, parent);
        if (!(eObject instanceof CMNNamedElement)) {
            throw new IllegalArgumentException("CMNNamedElementProxyNode can only be built upon CMNNamedElement");
        }
        CMNNamedElement namedElement = (CMNNamedElement)eObject;
        this.name = namedElement.getName();
        this.description = namedElement.getDescription();
    }

    public String getText() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProxyNodeRenamer2.class) {
            return this;
        }
        if (adapter == IProxyNodeRenamer.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isApplicableFor() {
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchWindow window = workbenchWindows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorReference[] refs = page.getEditorReferences();
                int k = 0;
                while (k < refs.length) {
                    IFile fileEdited;
                    IEditorInput input;
                    IEditorPart editor;
                    if (refs[k].isDirty() && (editor = refs[k].getEditor(false)) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && (fileEdited = ((IFileEditorInput)input).getFile()).equals((Object)this.getUnderlyingResource())) {
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean performRename(String newName) {
        CMNNamedElement eObject = (CMNNamedElement)this.getEObject();
        Resource res = eObject.eResource();
        if (res == null) {
            res = EMFUtil.getResource(null, (EObject)eObject);
        }
        if (!eObject.getName().equals(newName)) {
            eObject.setName(newName);
            if (res != null) {
                try {
                    EMFUtil.save((Resource)res);
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                }
            }
        }
        if (res != null) {
            res.unload();
        }
        return false;
    }

    public RenamerUIStatus performUserInteraction(String oldName) {
        return new RenamerUIInlineEditor();
    }

    public boolean saveState(IMemento memento) {
        if (this instanceof IPersistableProxyNode) {
            memento.putString(TAG_NAME, this.getText());
            return super.saveState(memento);
        }
        return false;
    }

    public Change createRenameChange(IRefactoringContext context, String newName) {
        if (this.getAdapter(IFile.class) != null) {
            IPath oldPath = this.getUnderlyingResource().getFullPath();
            IPath newPath = oldPath.removeLastSegments(1).append((IPath)new Path(String.valueOf(newName) + '.' + oldPath.getFileExtension()));
            return new RenameModelChange(this, context, newPath, newName);
        }
        return new RenameElementChange(this, context, newName);
    }

    protected class RenameElementChange
    extends Change {
        private EMFRefactoringTransaction context;
        private String newName;
        private CMNNamedElementProxyNode proxy;

        public RenameElementChange(CMNNamedElementProxyNode node, IRefactoringContext context, String newName) {
            this.proxy = node;
            this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
            this.newName = newName;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (this.context != null) {
                EObject object = this.context.getResourceSet().getEObject(CMNNamedElementProxyNode.this.getOriginatorURI(), true);
                ((CMNNamedElement)object).setName(this.newName);
                this.context.addSavedResource(object.eResource());
            }
            return null;
        }

        public Object getModifiedElement() {
            return this.proxy;
        }

        public String getName() {
            return NLS.bind((String)RefactoringMessages.RENAME_PROXY, (Object)this.proxy.getText(), (Object)this.newName);
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }
    }

    protected class RenameModelChange
    extends MoveModelChange {
        private IRefactoringContext context;
        private String newName;

        public RenameModelChange(EObjectProxyNode node, IRefactoringContext context, IPath destinationPath, String newName) {
            super(node, context, destinationPath);
            this.context = context;
            this.newName = newName;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Change change = super.perform(pm);
            EMFRefactoringTransaction t = (EMFRefactoringTransaction)this.context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
            if (t != null) {
                EObject object = t.getResourceSet().getEObject(CMNNamedElementProxyNode.this.getOriginatorURI(), false);
                ((CMNNamedElement)object).setName(this.newName);
            }
            return change;
        }

        protected void handleFileAlreadyExists(RefactoringStatus status) {
            status.addError(NLS.bind((String)RefactoringMessages.ALREADY_EXISTS_PROXY_DURING_RENAME, (Object)this.destination.toPortableString()));
        }

        public String getName() {
            return NLS.bind((String)RefactoringMessages.RENAME_PROXY, (Object)this.proxy.getText(), (Object)this.destination.removeFileExtension().lastSegment());
        }
    }
}

