/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestComponentlProxyNode;
import org.eclipse.hyades.test.ui.navigator.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

public class DefaultTypedElementProxyFactory
implements IPersistableTypedElementProxyFactory {
    public IProxyNode recreate(IMemento memento, Object parent) {
        String nodeKind = memento.getString("nodeKind");
        if (nodeKind.equals("testSuiteNode")) {
            return new DefaultTestSuiteProxyNode(memento, parent);
        }
        if (nodeKind.equals("testCaseNode")) {
            return new DefaultTestCaseProxyNode(memento, parent);
        }
        if (nodeKind.equals("executionResultNode")) {
            return new DefaultExecutionResultProxyNode(memento, parent);
        }
        if (nodeKind.equals("testComponentNode")) {
            return new DefaultTestComponentlProxyNode(memento, parent);
        }
        return null;
    }

    public IProxyNode create(TPFExecutionResult result, Object parent) {
        return new DefaultExecutionResultProxyNode(result, parent);
    }

    public IProxyNode create(TPFTest test, Object parent) {
        if (test instanceof TPFTestSuite) {
            return new DefaultTestSuiteProxyNode((TPFTestSuite)test, parent);
        }
        if (test instanceof TPFTestCase) {
            return new DefaultTestCaseProxyNode((TPFTestCase)test, parent);
        }
        return null;
    }

    public IProxyNode create(TPFTestComponent component, Object parent) {
        return new DefaultTestComponentlProxyNode(component, parent);
    }
}

