/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ArtifactProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DeploymentProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.ui.IMemento;

public class HyadesProxyNodeFactory {
    private static HyadesProxyNodeFactory instance;

    public static HyadesProxyNodeFactory getInstance() {
        if (instance == null) {
            instance = new HyadesProxyNodeFactory();
        }
        return instance;
    }

    private HyadesProxyNodeFactory() {
    }

    private boolean isAKnownType(TPFTestSuite ts) {
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        if (associationMapping == null) {
            return false;
        }
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(ts.getType());
        return descriptor != null;
    }

    private boolean isAKnownType(TPFTestCase tc) {
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        if (associationMapping == null) {
            return false;
        }
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(tc.getType());
        return descriptor != null;
    }

    public IProxyNode create(EObject eObject, Object parent) {
        if (eObject instanceof TPFTestSuite) {
            if (this.isAKnownType((TPFTestSuite)eObject)) {
                String type = ((TPFTestSuite)eObject).getType();
                ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
                if (factory != null) {
                    return factory.create((TPFTest)((TPFTestSuite)eObject), parent);
                }
                return null;
            }
            return null;
        }
        if (eObject instanceof TPFTestCase) {
            if (this.isAKnownType((TPFTestCase)eObject)) {
                String type = ((TPFTestCase)eObject).getType();
                ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
                if (factory != null) {
                    return factory.create((TPFTest)((TPFTestCase)eObject), parent);
                }
                return null;
            }
            return null;
        }
        if (eObject instanceof TPFExecutionResult) {
            String type = ((TPFExecutionResult)eObject).getType();
            ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
            if (factory != null) {
                return factory.create((TPFExecutionResult)eObject, parent);
            }
            return null;
        }
        if (eObject instanceof TPFTestComponent) {
            String type = ((TPFTestComponent)eObject).getType();
            ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
            if (factory != null) {
                return factory.create((TPFTestComponent)eObject, parent);
            }
            return null;
        }
        if (eObject instanceof DPLDatapool) {
            return new DatapoolProxyNode((DPLDatapool)eObject, parent);
        }
        if (eObject instanceof TPFDeployment) {
            return new DeploymentProxyNode((TPFDeployment)eObject, parent);
        }
        if (eObject instanceof CFGArtifact) {
            return new ArtifactProxyNode((CFGArtifact)eObject, parent);
        }
        if (eObject instanceof CFGLocation) {
            return new LocationProxyNode((CFGLocation)eObject, parent);
        }
        return null;
    }

    public IProxyNode recreate(IMemento memento, Object parent) {
        ITypedElementProxyFactory factory;
        String nodeKind = memento.getString("nodeKind");
        if (nodeKind.equals("artifactNode")) {
            return new ArtifactProxyNode(memento, parent);
        }
        if (nodeKind.equals("datapoolNode")) {
            return new DatapoolProxyNode(memento, parent);
        }
        if (nodeKind.equals("deployNode")) {
            return new DeploymentProxyNode(memento, parent);
        }
        if (nodeKind.equals("locationNode")) {
            return new LocationProxyNode(memento, parent);
        }
        if ((nodeKind.equals("testSuiteNode") || nodeKind.equals("executionResultNode") || nodeKind.equals("testCaseNode") || nodeKind.equals("testComponentNode")) && (factory = TypedElementFactoryManager.getInstance().getFactory(memento.getString("type"))) instanceof IPersistableTypedElementProxyFactory) {
            return ((IPersistableTypedElementProxyFactory)factory).recreate(memento, parent);
        }
        return null;
    }
}

