/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TestFolderProxyNode
implements IProxyNodeRenamer,
IResourceChangeListenerProxyNode,
IExtendedProxyNode {
    private IContainer container;
    private Object parent;
    private IProxyNode[] children;
    private ITestFolderContentValidator validator;
    private boolean flat;
    private IFileProxyManager fileProxyManager;

    public static TestFolderProxyNode create(IContainer container, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, boolean flat, Object parent) {
        TestFolderProxyNode proxy = new TestFolderProxyNode(container, validator, fileProxyManager, flat, parent);
        if (proxy.getChildren().length > 0) {
            return proxy;
        }
        return null;
    }

    protected TestFolderProxyNode(IContainer container, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, boolean flat, Object parent) {
        this(container, validator, fileProxyManager, flat, parent, true);
    }

    protected TestFolderProxyNode(IContainer container, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, boolean flat, Object parent, boolean computeChildren) {
        this.container = container;
        this.validator = validator;
        this.parent = parent;
        this.flat = flat;
        this.fileProxyManager = fileProxyManager;
        if (computeChildren) {
            this.computeChildren();
        }
    }

    protected final void computeChildren() {
        LinkedList _children = new LinkedList();
        this.buildChildren(_children, this.container);
        this.children = _children.toArray(new IProxyNode[_children.size()]);
    }

    protected void buildChildren(List _children, IContainer cont) {
        IResource[] resources = null;
        if (cont != null && cont.isAccessible()) {
            try {
                resources = cont.members();
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                _children = new LinkedList<IProxyNode>();
                return;
            }
            int i = 0;
            while (i < resources.length) {
                if (!TestNavigator.getFiltersManager().filter(resources[i])) {
                    IProxyNode node;
                    if (resources[i].getType() != 1) {
                        if (this.flat) {
                            this.buildChildren(_children, (IContainer)resources[i]);
                        } else {
                            IResourceChangeListenerProxyNode proxyFolder = this.createChildFolderProxyNode((IContainer)resources[i]);
                            if (proxyFolder != null) {
                                _children.add(proxyFolder);
                            }
                        }
                    } else if (this.validator.isFileOk((IFile)resources[i]) && this.validator.isProxyOk(node = this.createChildFileProxyNode((IFile)resources[i])) && !TestNavigator.getFiltersManager().filter(node)) {
                        _children.add(node);
                        this.fileProxyManager.cacheProxy((IFile)resources[i], node);
                    }
                }
                ++i;
            }
        }
    }

    protected IResourceChangeListenerProxyNode createChildFolderProxyNode(IContainer container) {
        return TestFolderProxyNode.create(container, this.validator, this.fileProxyManager, this.flat, this);
    }

    protected IProxyNode createChildFileProxyNode(IFile file) {
        return this.getFileProxyManager().getProxy(file, this);
    }

    public String getText() {
        return this.container.getName();
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    public Object getParent() {
        return this.parent;
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public IResource getUnderlyingResource() {
        return this.container;
    }

    public String getIdentifier() {
        return this.getText();
    }

    public boolean isApplicableFor() {
        return true;
    }

    public RenamerUIStatus performUserInteraction(String oldName) {
        return new RenamerUIInlineEditor();
    }

    public boolean performRename(String newName) {
        if (!newName.equals(this.container.getName())) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(newName, this.container.getType());
            if (!status.isOK()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)status.getMessage());
            } else {
                final IPath newPath = this.container.getFullPath().removeLastSegments(1).append(newName);
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            TestFolderProxyNode.this.container.move(newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class || adapter == IContainer.class) {
            return this.container;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private IProxyNode getProxy(IResource resource) {
        int i = 0;
        while (i < this.children.length) {
            if (resource.equals((Object)this.children[i].getUnderlyingResource())) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    private boolean addChild(IProxyNode proxy) {
        if (proxy == null) {
            return false;
        }
        IProxyNode[] newChildren = new IProxyNode[this.children.length + 1];
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].equals(proxy)) {
                return false;
            }
            newChildren[i] = this.children[i];
            ++i;
        }
        newChildren[this.children.length] = proxy;
        this.children = newChildren;
        return true;
    }

    private void addChildren(IProxyNode[] children2) {
        IProxyNode[] newChildren = new IProxyNode[this.children.length + children2.length];
        int i = 0;
        while (i < this.children.length) {
            newChildren[i] = this.children[i];
            ++i;
        }
        int j = 0;
        while (j < children2.length) {
            newChildren[i++] = children2[j];
            ++j;
        }
        this.children = newChildren;
    }

    private void replaceChild(IProxyNode oldProxy, IProxyNode newProxy) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == oldProxy) {
                this.children[i] = newProxy;
                break;
            }
            ++i;
        }
    }

    private void removeChild(IProxyNode proxy) {
        IProxyNode[] newChildren = new IProxyNode[this.children.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] != proxy) {
                newChildren[j++] = this.children[i];
            }
            ++i;
        }
        this.children = newChildren;
    }

    public IProxyNode resourceChanged(IResourceDelta rootDelta) {
        IProxyNode lowestChanged = null;
        IResourceDelta[] res = rootDelta.getAffectedChildren();
        int i = 0;
        while (i < res.length) {
            int kind = res[i].getKind();
            IProxyNode lowestChild = null;
            if (kind == 1) {
                lowestChild = this.updateADDED(res[i]);
            } else if (kind == 2) {
                lowestChild = this.updateREMOVED(res[i]);
            } else if (kind == 4) {
                lowestChild = this.updateCHANGED(res[i]);
            }
            if (lowestChild != null) {
                lowestChanged = lowestChanged == null ? lowestChild : this;
            }
            ++i;
        }
        return lowestChanged;
    }

    private IProxyNode updateADDED(IResourceDelta delta) {
        IResource resource = delta.getResource();
        int resType = resource.getType();
        if (resType == 1) {
            boolean wasAdded;
            IProxyNode newProxy;
            if (this.validator.isFileOk((IFile)resource) && this.validator.isProxyOk(newProxy = this.fileProxyManager.getProxy((IFile)resource, this)) && (wasAdded = this.addChild(newProxy))) {
                this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                return this;
            }
        } else if (resType == 2) {
            return this.updateADDEDFolder(resource);
        }
        return null;
    }

    private IProxyNode updateADDEDFolder(IResource resource) {
        IResourceChangeListenerProxyNode newFolderProxy = this.createChildFolderProxyNode((IContainer)((IFolder)resource));
        if (newFolderProxy != null) {
            if (this.flat) {
                this.addChildren(newFolderProxy.getChildren());
            } else {
                this.addChild(newFolderProxy);
            }
            return this;
        }
        return null;
    }

    private IProxyNode updateCHANGED(IResourceDelta delta) {
        IResource resource = delta.getResource();
        int resType = resource.getType();
        int flags = delta.getFlags();
        if (resType == 1) {
            return this.updateCHANGEDFile(resource, flags);
        }
        if (resType == 2) {
            return this.updateCHANGEDFolder(delta, resource);
        }
        return null;
    }

    private IProxyNode updateCHANGEDFile(IResource resource, int flags) {
        IProxyNode proxy = this.getProxy(resource);
        if ((flags & 0x100) != 0) {
            if (proxy != null) {
                if (this.validator.isFileOk((IFile)resource)) {
                    this.fileProxyManager.uncacheProxy((IFile)resource);
                    IProxyNode newProxy = this.fileProxyManager.getProxy((IFile)resource, this);
                    if (this.validator.isProxyOk(newProxy)) {
                        this.replaceChild(proxy, newProxy);
                        this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                    } else {
                        this.removeChild(proxy);
                    }
                    return this;
                }
            } else {
                boolean wasAdded;
                IProxyNode newProxy;
                if (this.validator.isFileOk((IFile)resource) && this.validator.isProxyOk(newProxy = this.fileProxyManager.getProxy((IFile)resource, this)) && (wasAdded = this.addChild(newProxy))) {
                    this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                    return this;
                }
                return null;
            }
        }
        return null;
    }

    private IProxyNode updateCHANGEDFolder(IResourceDelta delta, IResource resource) {
        IProxyNode proxy = this.getProxy(resource);
        if (proxy != null) {
            if (proxy instanceof IResourceChangeListenerProxyNode) {
                IProxyNode lowestChanged = ((IResourceChangeListenerProxyNode)proxy).resourceChanged(delta);
                if (proxy.getChildren().length == 0) {
                    this.removeChild(proxy);
                    lowestChanged = this;
                }
                return lowestChanged;
            }
        } else {
            if (!this.flat) {
                return this.updateADDEDFolder(resource);
            }
            return this.resourceChanged(delta);
        }
        UiPlugin.logError("The proxy node derived from a folder should be a TestFolderProxyNode");
        return null;
    }

    private IProxyNode updateREMOVED(IResourceDelta delta) {
        IResource resource = delta.getResource();
        int resType = resource.getType();
        if (resType == 1) {
            IProxyNode proxy2Remove = this.getProxy(resource);
            if (proxy2Remove != null) {
                this.fileProxyManager.uncacheProxy((IFile)resource);
                this.removeChild(proxy2Remove);
                return this;
            }
            return null;
        }
        if (resType == 2) {
            IProxyNode proxy2Remove = this.getProxy(resource);
            if (proxy2Remove != null) {
                if (proxy2Remove instanceof IResourceChangeListenerProxyNode) {
                    ((IResourceChangeListenerProxyNode)proxy2Remove).resourceChanged(delta);
                    this.removeChild(proxy2Remove);
                    return this;
                }
                UiPlugin.logError("The proxy node derived from a folder should be a IResourceChangeListenerProxyNode");
            } else {
                if (!this.flat) {
                    return null;
                }
                return this.resourceChanged(delta);
            }
        }
        return null;
    }

    protected final boolean isFlat() {
        return this.flat;
    }

    protected final ITestFolderContentValidator getValidator() {
        return this.validator;
    }

    protected final IFileProxyManager getFileProxyManager() {
        return this.fileProxyManager;
    }

    public IResource getCorrespondingResource() {
        return this.isFlat() ? null : this.container;
    }
}

