/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.testgen.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.hyades.test.core.testgen.ITestgenListener;
import org.eclipse.hyades.test.core.testgen.TestGenerator;
import org.eclipse.hyades.test.core.testgen.TestGenerator2;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class TestgenUtil {
    public static void launchGenerator(final IFile recFile, final String testgenFile, final String testgenID, final ITestgenListener[] listeners, String name) {
        Job testGenJob = new Job(name){

            public IStatus run(IProgressMonitor monitor) {
                TestGenerator generator;
                boolean bSuccess = false;
                IConfigurationElement element = TestGeneratorFactory.getInstance().getGeneratorConfigElement(testgenID);
                if (element == null) {
                    UiPlugin.logError(NLS.bind((String)UiPluginResourceBundle.TESTGEN_LOAD_ERR_, (Object)testgenID));
                    return this.finish(Status.CANCEL_STATUS);
                }
                try {
                    generator = (TestGenerator)element.createExecutableExtension("class");
                    generator.initialize(recFile, testgenFile, monitor);
                    bSuccess = generator.runTestGen(monitor);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    bSuccess = false;
                    return this.finish(Status.CANCEL_STATUS);
                }
                if (generator != null && bSuccess) {
                    if (Display.getDefault() != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                String[] outputFiles = null;
                                outputFiles = generator instanceof TestGenerator2 ? ((TestGenerator2)generator).getOutputFiles() : new String[]{generator.getOutputFileName()};
                                IWorkbenchWindow activeWorkbenchWindow = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                                int counter = 0;
                                while (counter < outputFiles.length) {
                                    IFile outputFile = workspaceRoot.getFile((IPath)new Path(outputFiles[counter]));
                                    TestgenUIUtility.selectAndReveal((IResource)outputFile, activeWorkbenchWindow);
                                    TestUIUtil.openEditor(outputFile, "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart");
                                    ++counter;
                                }
                            }
                        });
                    }
                    return this.finish(Status.OK_STATUS);
                }
                return this.finish(Status.CANCEL_STATUS);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private IStatus finish(IStatus status) {
                boolean bSuccess = false;
                if (status.equals(Status.OK_STATUS)) {
                    bSuccess = true;
                }
                if (listeners == null || listeners.length == 0) {
                    return status;
                }
                ITestgenListener[] iTestgenListenerArray = listeners;
                synchronized (listeners) {
                    int i = 0;
                    while (i < listeners.length) {
                        ITestgenListener li = listeners[i];
                        li.notifyEnd(bSuccess);
                        ++i;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return status;
                }
            }
        };
        testGenJob.setUser(true);
        testGenJob.schedule();
    }
}

