/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.test.core.util.LocationUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.LocationHostNameWizardPage;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

public class LocationNewWizard
extends HyadesNewWizard {
    private CFGMachineConstraint newLocation = null;
    private LocationHostNameWizardPage hostnamePage = null;
    private TestLocationPage testLocationPage = null;

    public LocationNewWizard() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_LOCATION_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("new_location_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("LocationNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("LocationNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected LocationPage getLocationPage() {
        if (this.testLocationPage == null) {
            this.testLocationPage = new TestLocationPage("locationLocation", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.testLocationPage.setFileExtension(fileExtension);
                this.testLocationPage.setFileName("");
            }
        }
        return this.testLocationPage;
    }

    protected String getType() {
        return "org.eclipse.hyades.location.generic";
    }

    public String getFileExtension() {
        return "location";
    }

    public void addPages() {
        this.getLocationPage().setTitle(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_TTL);
        this.getLocationPage().setDescription(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_LOC_DSC);
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_TTL);
        this.getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_ATT_DSC);
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        this.addLocationDetailsPage();
    }

    protected void addLocationDetailsPage() {
        this.hostnamePage = new LocationHostNameWizardPage();
        this.addPage((IWizardPage)this.hostnamePage);
    }

    protected boolean createObject(IFile file) throws Exception {
        String hostname = this.hostnamePage.getHostname();
        LocationUtil.createNew((IFile)file, (String)this.getLocationPage().getFileNameWithoutExtension(), (String)this.getAttributeWizardPage().getItemDescription(), (String)hostname);
        return true;
    }

    protected void openEditor(IFile file) throws PartInitException {
        TestUIUtil.openEditor(file, "org.eclipse.hyades.test.ui.editor.LocationEditorPart");
    }

    public CFGLocation getNewLocation() {
        return this.newLocation;
    }
}

