/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.TestNavigatorFilter;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;

public class TestLocationPage
extends LocationPage {
    public TestLocationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.addFilter(new TestNavigatorFilter());
        this.setNewProjectWizardCategory("org.eclipse.hyades.test.ui.wizards.new");
    }

    protected boolean validatePage(boolean updateMessage) {
        if (!super.validatePage(updateMessage)) {
            return false;
        }
        if (!TestUIUtil.isFilePathValid(this.getContainerFullPath().toString())) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(UiPluginResourceBundle.TestLocationPage_INVALID_CONTAINER);
            }
            return false;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getFilePath()));
        switch (TestUIUtil.validateResourcePath(file.getName(), file.getParent())) {
            case 2: 
            case 5: {
                if (updateMessage) {
                    this.setMessage(null);
                    this.setErrorMessage(UiPluginResourceBundle.TestLocationPage_INVALID_NAME);
                }
                return false;
            }
            case 1: 
            case 4: {
                if (updateMessage) {
                    this.setMessage(null);
                    this.setErrorMessage(UiPluginResourceBundle.TestLocationPage_TOO_LONG_NAME);
                }
                return false;
            }
        }
        if (updateMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return true;
    }
}

