/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.test.internal.recorder.ui.wizards;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IPrimaryRecorderPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;
import org.eclipse.ui.PlatformUI;

public class NewRecordingWizardPage
extends WizardPage
implements IPrimaryRecorderPage {
    private IGenericRecorderWizard wizard;
    private Button btnNewRec = null;
    private Button btnExistRec = null;
    private Button btnAdvanced = null;
    private Label lblRec = null;
    private Label lblTestgen = null;
    private Combo cmbTestgen1 = null;
    private Table listRecorders = null;
    private String[] registeredRecorders;
    private List<IConfigurationElement> registeredTestGeneratorConfigurationElements = null;
    private boolean bShowAdvanced = false;
    private Label lblDesc = null;
    private Set imagesToDispose = new HashSet();
    private static final String KEY_IS_NEW_REC = "GenRec_IsNewRec";
    private static final String KEY_RECORDER_ID = "GenRec_RecID";
    private static final String KEY_TESTGEN_ID = "GenRec_TestgenID";

    public NewRecordingWizardPage(IGenericRecorderWizard wizard) {
        super(NewRecordingWizardPage.class.getName(), UiPluginResourceBundle.NewRecordingWizardPage_TITLE, null);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".recw0001");
        this.setPageComplete(false);
        this.setDescription(UiPluginResourceBundle.NewRecordingWizardPage_DESCRIPTION);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.btnNewRec = new Button(composite, 16);
        this.btnNewRec.setText(UiPluginResourceBundle.NewRecordingWizardPage_BTN_NEW_REC);
        GridData gd = new GridData(768);
        this.btnNewRec.setLayoutData((Object)gd);
        this.btnExistRec = new Button(composite, 16);
        this.btnExistRec.setText(UiPluginResourceBundle.NewRecordingWizardPage_BTN_EXIST_REC);
        gd = new GridData(768);
        this.btnExistRec.setLayoutData((Object)gd);
        this.btnNewRec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRecordingWizardPage.this.wizard.notifyRecorderChanged();
                NewRecordingWizardPage.this.setPageComplete(NewRecordingWizardPage.this.validatePage());
                super.widgetSelected(e);
            }
        });
        this.btnExistRec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRecordingWizardPage.this.wizard.notifyRecorderChanged();
                NewRecordingWizardPage.this.setPageComplete(NewRecordingWizardPage.this.validatePage());
                super.widgetSelected(e);
            }
        });
        this.layoutRecorders(composite);
        this.layoutTestgen(composite);
        this.redrawControl();
        this.doDefaultEvents();
    }

    private void layoutRecorders(Composite composite) {
        this.lblRec = new Label(composite, 0);
        this.lblRec.setText(UiPluginResourceBundle.NewRecordingWizardPage_SELECT_RECORDER);
        this.listRecorders = new Table(composite, 67584);
        GridData gd = new GridData(1808);
        this.listRecorders.setLayoutData((Object)gd);
        this.listRecorders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRecordingWizardPage.this.recorderChanged();
            }
        });
        this.listRecorders.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (NewRecordingWizardPage.this.getSelectedRecorder() != null && NewRecordingWizardPage.this.canFlipToNextPage()) {
                    NewRecordingWizardPage.this.getContainer().showPage(NewRecordingWizardPage.this.getNextPage());
                }
            }
        });
        this.addRegisteredRecorders();
        this.lblDesc = new Label(composite, 64);
        this.lblDesc.setVisible(false);
        this.lblDesc.setLayoutData((Object)new GridData(768));
    }

    private void recorderChanged() {
        int nSelectedRec = this.listRecorders.getSelectionIndex();
        this.wizard.notifyRecorderChanged();
        this.populateRegisteredTestgenNew();
        this.updateDescriptionText();
        if (nSelectedRec > -1 && this.isTestgenValid() && (this.btnExistRec.getSelection() || this.btnNewRec.getSelection())) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void layoutTestgen(Composite composite) {
        this.btnAdvanced = new Button(composite, 0);
        this.btnAdvanced.setText(UiPluginResourceBundle.showAdvanced);
        this.btnAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRecordingWizardPage.this.bShowAdvanced = !NewRecordingWizardPage.this.bShowAdvanced;
                NewRecordingWizardPage.this.redrawControl();
                super.widgetSelected(e);
            }
        });
        this.lblTestgen = new Label(composite, 0);
        this.lblTestgen.setText(UiPluginResourceBundle.NewRecordingWizardPage_SELECT_TESTGEN);
        this.cmbTestgen1 = new Combo(composite, 8);
        this.cmbTestgen1.setLayoutData((Object)new GridData(768));
    }

    public String getSelectedRecorder() {
        if (this.listRecorders.getSelectionIndex() > -1) {
            return this.registeredRecorders[this.listRecorders.getSelectionIndex()];
        }
        return "";
    }

    public boolean isNewRecording() {
        return this.btnNewRec.getSelection();
    }

    private void doDefaultEvents() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        store.setDefault(KEY_IS_NEW_REC, true);
        boolean bNew = store.getBoolean(KEY_IS_NEW_REC);
        this.btnNewRec.setSelection(bNew);
        this.btnExistRec.setSelection(!bNew);
        if (this.selectRecorder(store.getString(KEY_RECORDER_ID))) {
            this.recorderChanged();
        }
        this.selectGenerator(store.getString(KEY_TESTGEN_ID));
    }

    private boolean selectRecorder(String id) {
        if (id == null || id.length() < 1) {
            return false;
        }
        int i = 0;
        while (i < this.registeredRecorders.length) {
            if (id.equals(this.registeredRecorders[i])) {
                this.listRecorders.deselectAll();
                this.listRecorders.select(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean selectGenerator(String id) {
        if (id != null && id.trim().length() > 0) {
            int counter = 0;
            while (counter < this.registeredTestGeneratorConfigurationElements.size()) {
                if (id.equals(this.registeredTestGeneratorConfigurationElements.get(counter).getAttribute("id"))) {
                    this.cmbTestgen1.select(counter);
                    return true;
                }
                ++counter;
            }
        }
        return false;
    }

    private void addRegisteredRecorders() {
        this.listRecorders.removeAll();
        this.imagesToDispose.clear();
        RecorderFactory factory = RecorderFactory.getInstance();
        String[] ids = factory.getRegisteredRecorderID();
        Image defaultImage = TestUIImages.INSTANCE.getImage("gen_record_obj.gif");
        this.registeredRecorders = new String[ids.length];
        int i = 0;
        while (i < ids.length) {
            TableItem item = new TableItem(this.listRecorders, 0);
            item.setText(factory.getRecorderName(ids[i]));
            URL url = factory.getRecorderIconURL(ids[i]);
            Image image = null;
            if (url != null) {
                image = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            if (image == null) {
                image = defaultImage;
            }
            item.setImage(image);
            this.registeredRecorders[i] = ids[i];
            if (image != defaultImage) {
                this.imagesToDispose.add(image);
            }
            ++i;
        }
        if (this.listRecorders.getSelectionIndex() > -1) {
            this.listRecorders.select(this.listRecorders.getSelectionIndex());
        }
        if (ids.length == 0) {
            this.listRecorders.setEnabled(false);
            this.lblRec.setEnabled(false);
            this.setMessage(UiPluginResourceBundle.NewRecordingWizardPage_NO_RECORDERS_FOUND, 3);
            this.setPageComplete(false);
        }
    }

    private void populateRegisteredTestgenNew() {
        this.cmbTestgen1.removeAll();
        this.registeredTestGeneratorConfigurationElements = TestGeneratorFactory.getInstance().getGeneratorConfigurationElementsByRecorderID(this.getSelectedRecorder());
        if (this.registeredTestGeneratorConfigurationElements.size() > 0) {
            int counter = 0;
            while (counter < this.registeredTestGeneratorConfigurationElements.size()) {
                this.cmbTestgen1.add(this.registeredTestGeneratorConfigurationElements.get(counter).getAttribute("name"));
                ++counter;
            }
            this.cmbTestgen1.select(0);
        }
    }

    protected void updateDescriptionText() {
        String desc = RecorderFactory.getInstance().getRecorderDescription(this.getSelectedRecorder());
        if (desc == null || desc.equals("")) {
            this.lblDesc.setVisible(false);
            this.lblDesc.setText("");
            return;
        }
        this.lblDesc.setText(NLS.bind((String)UiPluginResourceBundle.NewRecordingWizardPage_DESCRIPTION_LBL, (Object)desc));
        this.lblDesc.setVisible(true);
        ((Composite)this.getControl()).layout(true);
    }

    protected void redrawControl() {
        if (this.bShowAdvanced) {
            this.btnAdvanced.setText(UiPluginResourceBundle.hideAdvanced);
            this.lblTestgen.setVisible(true);
            this.cmbTestgen1.setVisible(true);
        } else {
            this.btnAdvanced.setText(UiPluginResourceBundle.showAdvanced);
            this.cmbTestgen1.setVisible(false);
            this.lblTestgen.setVisible(false);
        }
        this.populateRegisteredTestgenNew();
    }

    protected boolean isTestgenValid() {
        return this.cmbTestgen1.getSelectionIndex() > -1;
    }

    protected boolean validatePage() {
        return (this.btnExistRec.getSelection() || this.btnNewRec.getSelection()) && this.isTestgenValid() && this.listRecorders.getSelectionIndex() > -1;
    }

    public String getRecorderData(String key) {
        if (key.equals("keyTestgenID")) {
            if (this.cmbTestgen1.getSelectionIndex() == -1) {
                return "-1";
            }
            return this.registeredTestGeneratorConfigurationElements.get(this.cmbTestgen1.getSelectionIndex()).getAttribute("id");
        }
        return null;
    }

    public Object getRecorderObjectData(String key) {
        return null;
    }

    public void saveSettings() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        store.setValue(KEY_IS_NEW_REC, this.btnNewRec.getSelection());
        store.setValue(KEY_RECORDER_ID, this.getSelectedRecorder());
        store.setValue(KEY_TESTGEN_ID, this.getRecorderData("keyTestgenID"));
    }

    public void dispose() {
        Iterator it = this.imagesToDispose.iterator();
        while (it.hasNext()) {
            ((Image)it.next()).dispose();
        }
        super.dispose();
    }
}

