/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.test.internal.recorder.ui.wizards;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderClientUI;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.internal.testgen.ui.TestgenUIWrapper;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.NewRecordingWizardPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.DefaultRecWizardProvider;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.RecLocationWizardPage;

public class NewTestFromRecordingWizard
extends HyadesWizard
implements IGenericRecorderWizard {
    protected NewRecordingWizardPage page1 = null;
    protected IGenericRecorderPage[] pages = new IGenericRecorderPage[0];
    protected IPath initSelection;

    public NewTestFromRecordingWizard() {
    }

    public NewTestFromRecordingWizard(IPath initialSelection) {
        this.initSelection = initialSelection;
    }

    public void createPageControls(Composite parent) {
        super.createPageControls(parent);
        this.setWindowTitle(UiPluginResourceBundle.NewRecordingWizardPage_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)UiPlugin.getDefault().getBundle().getEntry("icons/full/wizban/gen_record_wiz.gif")));
    }

    protected void initPages() {
        this.setForcePreviousAndNextButtons(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performFinish() {
        String recorderID = this.page1.getSelectedRecorder();
        if (this.page1.isNewRecording()) {
            IRecorderPageProvider wizardPages = (IRecorderPageProvider)RecorderFactory.getInstance().getWizardPageProvider(recorderID, false);
            if (!wizardPages.doFinish()) return false;
            RecorderClientUI.launchRecorder(wizardPages.getRecorder(), this);
        } else {
            String recPath = this.getRecorderData("keyWizardPath");
            if (RecorderFactory.getInstance().getRecorderFileExtension(this.getRecorderID()).equals("rec")) {
                recPath = String.valueOf(recPath) + "model";
            }
            String tgPath = this.getRecorderData("keyTestgenPath");
            IFile tgFile = UiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(tgPath));
            if (RecorderFileUtil.fileExists((IFile)tgFile)) {
                boolean b = MessageDialog.openConfirm((Shell)UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE, (String)UiPluginResourceBundle.DefaultRecWizardProvider_TESTSUITE_EXISTS);
                if (!b) {
                    return false;
                }
                RecorderFileUtil.deleteFile((IFile)tgFile);
            }
            TestgenUIWrapper wrapper = new TestgenUIWrapper(this.getRecorderData("keyTestgenID"), recPath, tgPath);
            wrapper.launchGenerator();
        }
        this.saveSettings();
        return true;
    }

    public void addPages() {
        this.page1 = new NewRecordingWizardPage(this);
        this.addPage(this.page1);
    }

    public String getRecorderID() {
        return this.page1.getSelectedRecorder();
    }

    public IGenericRecorderPage[] getProvidedPages(String recorderID) {
        IRecorderPageProvider provider = (IRecorderPageProvider)RecorderFactory.getInstance().getWizardPageProvider(recorderID, false);
        if (provider == null) {
            provider = new DefaultRecWizardProvider();
        }
        IGenericRecorderPage[] providerPages = provider.getWizardPages(this);
        if (!this.page1.isNewRecording()) {
            String recExtension = RecorderFactory.getInstance().getRecorderFileExtension(recorderID);
            if (recExtension == null) {
                recExtension = "recmodel";
            }
            IGenericRecorderPage[] allPages = new IGenericRecorderPage[providerPages.length + 1];
            allPages[0] = new RecLocationWizardPage(this, recExtension, true);
            System.arraycopy(providerPages, 0, allPages, 1, providerPages.length);
            return allPages;
        }
        return providerPages;
    }

    public void notifyRecorderChanged() {
        this.pages = this.getProvidedPages(this.page1.getSelectedRecorder());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.pages.length > 0) {
            if (page == this.page1) {
                return this.pages[0];
            }
            int i = 0;
            while (i < this.pages.length) {
                if (page == this.pages[i] && this.pages.length > i + 1) {
                    return this.pages[i + 1];
                }
                ++i;
            }
        }
        return super.getNextPage(page);
    }

    public void registerListeners() {
    }

    public void runTestGen(Recorder recorder) {
        String scriptGenID = recorder.getScriptgenID();
        if (scriptGenID == null || scriptGenID.equals("-1")) {
            return;
        }
        String scriptGenName = TestGeneratorFactory.getInstance().getGeneratorName(scriptGenID);
        String recordingPath = recorder.getRecordingPath();
        RecorderFactory.getInstance().controlMessage(recorder, "org.eclipse.hyades.test.core.controlviewmessage", String.valueOf(TestCorePluginResourceBundle.RecorderClient_Test_generation_started_with_generator___4) + " " + scriptGenName);
        IFile traceFile = recordingPath.endsWith(".rec") ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(recordingPath) + "model")) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(recordingPath));
        if (traceFile.exists()) {
            RecorderFactory.getInstance().controlMessage(recorder, "org.eclipse.hyades.test.core.controlviewmessage", String.valueOf(TestCorePluginResourceBundle.RecorderClient_TEST_TO_BE_GENERATED) + " " + recorder.getTestPath());
            TestgenUIWrapper wrapper = new TestgenUIWrapper(scriptGenID, traceFile, recorder.getTestPath());
            wrapper.addListener(RecorderControlView.getInstance());
            wrapper.launchGenerator();
        } else {
            RecorderFactory.getInstance().controlMessage(recorder, "org.eclipse.hyades.test.core.controlviewmessage", TestCorePluginResourceBundle.RecorderClient_UNABLE_TO_GENERATE_NO_TRACE_FILE);
        }
    }

    public void saveSettings() {
        this.page1.saveSettings();
        int i = 0;
        while (i < this.pages.length) {
            this.pages[i].saveSettings();
            ++i;
        }
    }

    public String getRecorderData(String key) {
        String testSuite;
        if (this.page1 == null) {
            return null;
        }
        if (this.page1.getRecorderData(key) != null) {
            return this.page1.getRecorderData(key);
        }
        int i = 0;
        while (i < this.pages.length) {
            if (this.pages[i].getRecorderData(key) != null) {
                return this.pages[i].getRecorderData(key);
            }
            ++i;
        }
        if (key.equals("keyWizardPath") && this.page1.isNewRecording() && (testSuite = this.getRecorderData("keyTestgenPath")) != null && testSuite.endsWith(".testsuite")) {
            String rec = testSuite.substring(0, testSuite.lastIndexOf(".testsuite"));
            String fileExt = RecorderFactory.getInstance().getRecorderFileExtension(this.getRecorderID());
            rec = String.valueOf(rec) + "." + fileExt;
            return rec;
        }
        return null;
    }

    public Object getRecorderObjectData(String key) {
        if (key.equals("keyWizardStructuredSelection")) {
            return this.selection;
        }
        if (this.page1 == null) {
            return null;
        }
        if (this.page1.getRecorderObjectData(key) != null) {
            return this.page1.getRecorderObjectData(key);
        }
        int i = 0;
        while (i < this.pages.length) {
            if (this.pages[i].getRecorderObjectData(key) != null) {
                return this.pages[i].getRecorderObjectData(key);
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        if (!this.page1.isPageComplete()) {
            return false;
        }
        if (this.pages == null) {
            return super.canFinish();
        }
        int i = 0;
        while (i < this.pages.length) {
            if (!this.pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean performCancel() {
        String recID = this.page1.getSelectedRecorder();
        IRecorderPageProvider provider = (IRecorderPageProvider)RecorderFactory.getInstance().getWizardPageProvider(recID, false);
        if (provider == null) {
            return super.performCancel();
        }
        return provider.doCancel();
    }
}

