/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;

public class TestsuiteLocationWizardPage
extends FileLocationSelectionWizardpage
implements IGenericRecorderPage {
    private IGenericRecorderWizard wizard;

    public TestsuiteLocationWizardPage(IGenericRecorderWizard wizard) {
        this(wizard, true);
    }

    public TestsuiteLocationWizardPage(IGenericRecorderWizard wizard, boolean bSaveLastSelected) {
        super(bSaveLastSelected, wizard != null ? (IStructuredSelection)wizard.getRecorderObjectData("keyWizardStructuredSelection") : null);
        this.wizard = wizard;
        this.setWizard((IWizard)wizard);
    }

    public void setVisible(boolean visible) {
        String recordingPathString;
        if (visible && this.wizard != null && (recordingPathString = this.wizard.getRecorderData("keyWizardPath")) != null && recordingPathString.length() > 0) {
            IPath recordingPath = new Path(recordingPathString).removeFileExtension();
            this.setContainerFullPath(recordingPath.removeLastSegments(1));
            this.setFileName(recordingPath.lastSegment());
        }
        super.setVisible(visible);
    }

    public String getDescription() {
        return UiPluginResourceBundle.TestsuiteLocationWizardPage_DESCRIPTION;
    }

    public String getFileExtension() {
        return "testsuite";
    }

    public String getTitle() {
        return UiPluginResourceBundle.NewRecordingWizardPage_TITLE;
    }

    public String getContextHelpID() {
        return String.valueOf(UiPlugin.getID()) + ".recw0001";
    }

    public String getRecorderData(String key) {
        if (key.equals("keyTestgenPath")) {
            return this.getFilePath();
        }
        return null;
    }

    public Object getRecorderObjectData(String key) {
        return null;
    }

    protected String getPreferenceKey() {
        return String.valueOf(super.getPreferenceKey()) + (this.wizard != null ? this.wizard.getRecorderID() : "");
    }

    protected boolean validatePage(boolean updateMessage) {
        if (!super.validatePage(updateMessage)) {
            return false;
        }
        try {
            if (!ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getFilePath())).getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                if (updateMessage) {
                    this.setMessage(null);
                    this.setErrorMessage(UiPluginResourceBundle.TestLocationPage_INCORRECT_CONTAINER_TYPE);
                }
                return false;
            }
        }
        catch (Exception exception) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(UiPluginResourceBundle.TestLocationPage_INCORRECT_CONTAINER_TYPE);
            }
            return false;
        }
        if (updateMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return true;
    }
}

