/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.common.provisional.TestlogFilenameExtensionManager;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;
import org.eclipse.hyades.models.common.util.ResourceCache;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.models.hierarchy.util.internal.EMFWorkspaceUtil;
import org.eclipse.hyades.models.util.ModelDebugger;

public class ExecutionContext {
    public static final boolean debug = true;
    public static char separator = (char)46;
    public static String root = "ROOT";
    private TPFTestSuite testSuite = null;
    private ResourceSet resourceSet;
    private URI testSuiteURI;
    private boolean databaseResource = false;
    protected ExecutionResultData rootResult = null;
    protected HashMap resultMap = new HashMap();
    private Resource resource = null;
    private String executionResultLocation;
    private String executionResultName;
    private URI executionURI;
    protected EObjectCache cache = null;
    private int agentCount = 0;
    private boolean testLogFile = false;

    public ExecutionContext(TPFTestSuite suite, String id, String executionResultLocation, String executionResultName) {
        this(suite, id, executionResultLocation, executionResultName, false, null);
    }

    public ExecutionContext(TPFTestSuite suite, String id, CFGLocation location, String executionResultLocation, String executionResultName) {
        this(suite, id, executionResultLocation, executionResultName);
        TPFDeployment deployment = location.getDeployment();
        if (deployment != null && !ConfigurationUtil.isDefaultDeployment(deployment)) {
            this.rootResult.getResult().setDeployment(deployment);
        }
    }

    public ExecutionContext(TPFTestSuite suite, String id, String executionResultLocation, String executionResultName, boolean overrideExisting, TPFDeployment deployment, boolean databaseResource, boolean testLogFile) {
        this.testSuite = suite;
        this.databaseResource = databaseResource;
        this.testLogFile = testLogFile;
        this.resourceSet = suite.eResource().getResourceSet();
        this.testSuiteURI = EcoreUtil.getURI((EObject)this.testSuite);
        this.executionResultLocation = executionResultLocation;
        if (executionResultName == null) {
            this.setExecutionResultName(suite.getName());
        } else {
            this.setExecutionResultName(executionResultName);
        }
        this.rootResult = new ExecutionResultData(this.getTestSuite(), suite.getId());
        if (!testLogFile) {
            this.resource = this.createExecutionResultResource(overrideExisting);
            this.resource.getContents().add((Object)this.rootResult.getResult());
            this.rootResult.getResult().setName(executionResultName);
            SaveManager.saveResource(this.resource);
            if (deployment != null && !ConfigurationUtil.isDefaultDeployment(deployment)) {
                this.rootResult.getResult().setDeployment(deployment);
            }
            this.cache = new EObjectCache(0);
        }
        this.resultMap.put(String.valueOf(this.getTestSuite().getId()) + "(1)", this.rootResult);
    }

    public ExecutionContext(TPFTestSuite suite, String id, String executionResultLocation, String executionResultName, boolean overrideExisting, TPFDeployment deployment) {
        this(suite, id, executionResultLocation, executionResultName, false, null, false, false);
    }

    protected Resource createExecutionResultResource(long timestamp) {
        return this.createExecutionResultResource(false);
    }

    protected Resource createExecutionResultResource(boolean overwrite) {
        if (!overwrite) {
            this.setExecutionResultName(String.valueOf(this.executionResultName) + '_' + System.currentTimeMillis());
        }
        this.executionURI = this.createURI(String.valueOf(this.getExecutionResultLocation()) + '/' + this.getExecutionResultName(this.databaseResource));
        if (this.getTestSuite().eResource().getResourceSet() == null) {
            ModelDebugger.log((String)("Unable to create execution result resource: " + this.formatURI(this.executionURI)));
            return null;
        }
        if (overwrite && EMFWorkspaceUtil.exists((URI)this.executionURI)) {
            if (EMFWorkspaceUtil.getFileFromURI((URI)this.executionURI).delete()) {
                if (RegistryReader.isWorkspaceMode()) {
                    try {
                        EMFWorkspaceUtil.refreshLocal((URI)this.executionURI);
                    }
                    catch (Exception e) {
                        ModelDebugger.log((Throwable)e);
                    }
                }
            } else {
                ModelDebugger.log((String)("Unable to delete existing execution result file: " + this.formatURI(this.executionURI)));
            }
        }
        return ResourceCache.getInstance().createSharedResource(this.executionURI, this.resourceSet);
    }

    private URI createURI(String filePath) {
        if (RegistryReader.isPlatformMode() && RegistryReader.isWorkspaceMode()) {
            return URI.createPlatformResourceURI((String)filePath, (boolean)false);
        }
        return URI.createFileURI((String)filePath);
    }

    private String formatURI(URI uri) {
        if (uri != null) {
            if (uri.isPlatform()) {
                return uri.toPlatformString(true);
            }
            if (uri.isFile()) {
                return uri.toFileString();
            }
            return uri.toString();
        }
        return null;
    }

    public TPFTestSuite getTestSuite() {
        EObject eObject;
        if (this.testSuite.eResource().getResourceSet() == null && (eObject = this.resourceSet.getEObject(this.testSuiteURI, true)) instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)eObject;
        }
        return this.testSuite;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getExecutionResultLocation() {
        return this.executionResultLocation;
    }

    protected String getExecutionResultName() {
        return this.getExecutionResultName(false);
    }

    protected String getExecutionResultName(boolean databaseResource) {
        if (databaseResource) {
            String s = ModelDebugger.INSTANCE.debugDatabaseResourcePostfix;
            return String.valueOf(this.executionResultName) + s.substring(0, s.indexOf(46)) + ".executiondb";
        }
        return String.valueOf(this.executionResultName) + "." + this.getFileExtension();
    }

    protected void setExecutionResultName(String name) {
        this.executionResultName = name != null && name.trim().endsWith("." + this.getFileExtension()) ? name.substring(0, name.lastIndexOf(46)) : name;
    }

    public void logEvent(TPFExecutionEvent event) {
        ExecutionMapData mapData = new ExecutionMapData(event.getOwnerId());
        ExecutionResultData data = mapData.getData();
        if (data == null) {
            this.reportErrorInEvent(event);
            return;
        }
        TPFExecutionHistory history = data.getHistory();
        event.setExecutionHistory(history);
        EObject eObject = data.getTest().eResource().getEObject(mapData.getOwnerId());
        if (event instanceof TPFInvocationEvent) {
            TPFTest test = this.getTestSuite();
            if (eObject instanceof BVRInteractionFragment) {
                event.setInteractionFragment((BVRInteractionFragment)eObject);
                TPFBehavior behavior = ((BVRExecutionOccurrence)eObject).getOtherBehavior();
                if (behavior.getTest() != null) {
                    test = behavior.getTest();
                }
            }
            ExecutionResultData child = new ExecutionResultData(test, event.getOwnerId());
            child.setInvocationEvent((TPFInvocationEvent)event);
            this.resultMap.put(child.getId(), child);
            ((TPFInvocationEvent)event).setExecutionHistory(data.getResult().getExecutionHistory());
        } else if (event instanceof TPFTypedEvent) {
            if (eObject instanceof TPFTest) {
                data.getResult().setTest((TPFTest)eObject);
            } else if (eObject instanceof BVRCombinedFragment) {
                event.setInteractionFragment((BVRInteractionFragment)eObject);
            }
        } else if (event instanceof TPFVerdictEvent) {
            data.getResult().setVerdict(((TPFVerdictEvent)event).getVerdict());
        }
    }

    private void reportErrorInEvent(TPFExecutionEvent event) {
        System.err.println("Ignoring the following event due to invalid ownerId: ");
        System.err.println("Event    : " + event.getClass().getName());
        System.err.println("ownerId  : " + event.getOwnerId());
        System.err.println("text     : " + event.getText());
        System.err.println("timestamp: " + event.getTimestamp());
    }

    public void cleanUp() {
        if (!this.testLogFile) {
            SaveManager.saveResource(this.resource);
            ResourceCache.getInstance().releaseSharedResource(this.executionURI);
            this.cache.clear();
        }
        this.resultMap.clear();
    }

    public EObject getEObjectByID(String id) {
        Object obj = null;
        if (this.resource instanceof ResourceImpl && ((ResourceImpl)this.resource).getIntrinsicIDToEObjectMap() != null) {
            obj = ((ResourceImpl)this.resource).getIntrinsicIDToEObjectMap().get(id);
        } else {
            obj = this.cache.get(id);
            if (obj == null) {
                EObject newObj = this.resource.getEObject(id);
                if (newObj != null) {
                    this.cache.put(id, newObj);
                    return newObj;
                }
                throw new RuntimeException("unable to identify object by id");
            }
        }
        return obj;
    }

    public void putEObjectByID(String id, EObject obj) {
        if (this.resource instanceof ResourceImpl && ((ResourceImpl)this.resource).getIntrinsicIDToEObjectMap() != null) {
            ((ResourceImpl)this.resource).getIntrinsicIDToEObjectMap().put(id, obj);
        } else {
            this.cache.put(id, obj);
        }
    }

    public void removeEObjectByID(String id) {
        if (this.resource instanceof ResourceImpl && ((ResourceImpl)this.resource).getIntrinsicIDToEObjectMap() != null) {
            ((ResourceImpl)this.resource).getIntrinsicIDToEObjectMap().remove(id);
        } else {
            this.cache.remove(id);
        }
    }

    private String getFileExtension() {
        String customExtension = TestlogFilenameExtensionManager.getInstance().getExtensionForTestType(this.testSuite.getType());
        return customExtension != null ? customExtension : "execution";
    }

    public int decrementAgentCount() {
        return --this.agentCount;
    }

    public void incrementAgentCount() {
        ++this.agentCount;
    }

    protected class EObjectCache {
        private LinkedList order = null;
        private Hashtable map = new Hashtable(89);
        private int capacity = 0;

        public EObjectCache(int size) {
            this.order = new LinkedList();
            this.capacity = size == 0 ? Integer.MAX_VALUE : size;
        }

        public void clear() {
            this.map.clear();
            this.order.clear();
        }

        public void remove(String id) {
            this.map.remove(id);
        }

        public EObject get(String id) {
            Object obj = this.map.get(id);
            if (obj != null) {
                this.moveToFront(id);
                return (EObject)obj;
            }
            return null;
        }

        public void put(String id, EObject obj) {
            Object temp = this.map.get(id);
            if (temp != null) {
                this.moveToFront(id);
            } else {
                if (this.atCapacity()) {
                    this.removeLast();
                }
                this.insert(id, obj);
            }
        }

        private void insert(String id, EObject obj) {
            this.map.put(id, obj);
            if (this.capacity != Integer.MAX_VALUE) {
                this.order.add(0, id);
            }
        }

        private void moveToFront(String id) {
            int index;
            if (this.capacity != Integer.MAX_VALUE && (index = this.order.indexOf(id)) > 0) {
                Object obj = this.order.get(index);
                this.order.remove(index);
                this.order.addFirst(obj);
            }
        }

        private void removeLast() {
            if (this.capacity != Integer.MAX_VALUE) {
                String deadID = (String)this.order.getLast();
                this.map.remove(deadID);
                this.order.removeLast();
            }
        }

        private boolean atCapacity() {
            return this.map.size() >= this.capacity;
        }
    }

    public class ExecutionMapData {
        String parentId = null;
        String ownerId = null;
        ExecutionResultData data = null;

        public ExecutionMapData(String id) {
            if (id == null || id.equals("")) {
                return;
            }
            int index = id.lastIndexOf(separator);
            if (index < 0) {
                this.parentId = id;
                this.ownerId = this.stripParanthesis(id);
                this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                if (this.data == null) {
                    String testSuiteId = ExecutionContext.this.getTestSuite().getId();
                    String testSuiteBehaviorId = ExecutionContext.this.getTestSuite().getBehavior().getId();
                    if (this.parentId.compareTo(testSuiteId) == 0 || this.parentId.compareTo(testSuiteBehaviorId) == 0) {
                        this.data = ExecutionContext.this.rootResult;
                    }
                }
            } else {
                ExecutionMapData map;
                ExecutionResultData tempData;
                this.ownerId = id.substring(index + 1);
                this.ownerId = this.stripParanthesis(this.ownerId);
                this.parentId = id.substring(0, index);
                this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                if (this.data == null && (tempData = (map = new ExecutionMapData(this.parentId)).getData()) != null) {
                    EObject eObject = tempData.getObjectInTest(map.getOwnerId());
                    if (eObject instanceof BVRCombinedFragment) {
                        this.data = tempData;
                    } else if (eObject instanceof TPFTest) {
                        this.data = tempData;
                    } else if (eObject instanceof BVRExecutionOccurrence) {
                        TPFInvocationEvent invocationEvent = Common_TestprofileFactoryImpl.eINSTANCE.createTPFInvocationEvent();
                        invocationEvent.setOwnerId(this.parentId);
                        ExecutionContext.this.logEvent(invocationEvent);
                        this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                    }
                }
            }
        }

        private String stripParanthesis(String id) {
            String str = id;
            int index = str.lastIndexOf(40);
            if (index >= 0) {
                str = str.substring(0, index);
            }
            return str;
        }

        public String getOwnerId() {
            return this.ownerId;
        }

        public String getParentId() {
            return this.parentId;
        }

        public ExecutionResultData getData() {
            return this.data;
        }
    }
}

