/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.common.IXMLEventConstants;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNExtendedProperty;
import org.eclipse.hyades.models.common.common.CommonFactory;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;
import org.eclipse.hyades.models.common.util.FileUtil;
import org.eclipse.hyades.models.util.ModelDebugger;

public abstract class XMLexecutionEventLoader
extends IgnoredXMLFragmentLoader
implements IXMLEventConstants {
    public static final boolean DEBUG = false;
    public static final String ROOT_PARENT = "ROOT";
    protected static final String EVENT_ID = "id";
    protected static final String EVENT_OWNERID = "ownerId";
    protected static final String EVENT_OWNERTYPE = "ownerType";
    protected static final String EVENT_TIMESTAMP = "timestamp";
    protected static final String EVENT_TEXT = "text";
    protected static final String EVENT_PARENTID = "parentId";
    protected static final String EVENT_NAME = "name";
    protected static final String EVENT_EVENT_TYPE = "eventType";
    protected static final String EVENT_SORT_BY = "sortBy";
    protected static final String EVENT_CONFLICT = "conflict";
    protected static final String EVENT_PROPERTY = "property";
    protected static final String EVENT_PROPERTY_NAME = "pname";
    protected static final String EVENT_PROPERTY_TYPE = "ptype";
    protected static final String EVENT_PROPERTY_VALUE = "pvalue";
    protected static final String EVENT_ANNOTATION = "annotation";
    protected static final String EVENT_ANNOTATION_FILENAME = "annotationFilename";
    protected static final String EVENT_ANNOTATION_TYPE = "annotationType";
    protected static final String EVENT_REPOSITORY_RECORD = "repositoryRecord";
    protected static final String EVENT_REPOSITORY_RECORD_ID = "repositoryRecordId";
    protected static final String EVENT_REPOSITORY_RECORD_URI = "repositoryRecordUri";
    protected static final String EVENT_REPOSITORY_RECORD_TYPE = "repositoryRecordType";
    protected static final String EVENT_REPOSITORY_RECORD_LABEL = "repositoryRecordLabel";
    protected String id = null;
    protected String ownerId = null;
    protected String ownerType = null;
    protected long timestamp = -1L;
    protected String text;
    protected TPFExecutionEvent event = null;
    protected String parentId = null;
    protected String name = null;
    protected String eventType = null;
    protected String sortBy = null;
    protected int conflict = 0;
    protected CMNExtendedProperty property = null;
    protected ArrayList properties = new ArrayList();
    protected CMNAnnotation annotation = null;
    protected String annotationFilename = null;
    protected char[] annotationCDATA = null;
    protected ArrayList annotations = new ArrayList();
    protected ArrayList repositoryRecords = new ArrayList();
    protected TPFRepositoryRecord repositoryRecord = null;
    protected static final Object ModelTraversalLock = new Object();

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.event = null;
        this.id = null;
        this.ownerId = null;
        this.ownerType = null;
        this.timestamp = 0L;
        this.text = null;
        this.parentId = null;
        this.name = null;
        this.eventType = null;
        this.sortBy = null;
        this.conflict = 0;
        this.property = null;
        this.properties.clear();
        this.annotation = null;
        this.annotationFilename = null;
        this.annotationCDATA = null;
        this.annotations.clear();
        this.repositoryRecords.clear();
        this.printTag(name);
    }

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3355: {
                this.id = value;
                break;
            }
            case -1054729426: {
                this.ownerId = value;
                break;
            }
            case 17654925: {
                this.ownerType = value;
                break;
            }
            case 1175162725: {
                this.parentId = value;
                break;
            }
            case 55126294: {
                this.timestamp = Long.parseLong(value);
                break;
            }
            case 3556653: {
                this.text = value;
                break;
            }
            case 3373707: {
                this.name = value;
                break;
            }
            case 31430900: {
                this.eventType = value;
                break;
            }
            case -896594283: {
                this.sortBy = value;
                break;
            }
            case -580047918: {
                this.conflict = Integer.parseInt(value);
                break;
            }
            case 106808059: {
                if (this.property == null) break;
                this.property.setName(value);
                break;
            }
            case 107009962: {
                if (this.property == null) break;
                this.property.setType(value);
                break;
            }
            case -976529663: {
                if (this.property == null) break;
                this.property.setValue(value);
                break;
            }
            case -959184298: {
                if (this.annotation == null) break;
                this.annotationFilename = value;
                break;
            }
            case 1444986633: {
                if (this.annotation == null) break;
                this.annotation.setType(value);
                break;
            }
            case 154860214: {
                if (this.repositoryRecord == null) break;
                this.repositoryRecord.setID(value);
                break;
            }
            case 505711409: {
                if (this.repositoryRecord == null) break;
                this.repositoryRecord.setURI(value);
                break;
            }
            case -1502838251: {
                if (this.repositoryRecord == null) break;
                this.repositoryRecord.setType(value);
                break;
            }
            case 648537977: {
                if (this.repositoryRecord == null) break;
                this.repositoryRecord.setLabel(value);
                break;
            }
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
        if (this.annotation != null) {
            if (this.annotationCDATA == null) {
                this.annotationCDATA = new char[length];
                System.arraycopy(data, offset, this.annotationCDATA, 0, length);
            } else {
                int size = this.annotationCDATA.length + length;
                char[] newData = new char[size];
                System.arraycopy(this.annotationCDATA, 0, newData, 0, this.annotationCDATA.length);
                System.arraycopy(data, offset, newData, this.annotationCDATA.length, length);
                this.annotationCDATA = newData;
                newData = null;
            }
        }
    }

    public void startChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -993141291: {
                this.property = CommonFactory.eINSTANCE.createCMNExtendedProperty();
                break;
            }
            case -1555043537: {
                this.annotation = CommonFactory.eINSTANCE.createCMNAnnotation();
                break;
            }
            case 2024739899: {
                this.repositoryRecord = Common_TestprofileFactory.eINSTANCE.createTPFRepositoryRecord();
            }
        }
        super.startChild(name);
    }

    public void endChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -993141291: {
                this.properties.add(this.property);
                this.property = null;
                break;
            }
            case -1555043537: {
                this.constructAnnotation();
                this.annotations.add(this.annotation);
                this.annotation = null;
                this.annotationFilename = null;
                this.annotationCDATA = null;
                break;
            }
            case 2024739899: {
                this.repositoryRecords.add(this.repositoryRecord);
                this.repositoryRecord = null;
            }
        }
        super.endChild(name);
    }

    public void addYourselfInContext() {
        if (this.event == null) {
            return;
        }
        this.printEndTag();
        this.event.setId(this.id);
        this.event.setOwnerId(this.ownerId);
        this.event.setTimestamp(this.timestamp);
        this.event.setText(this.text);
        this.event.setName(this.name);
        this.event.setEventType(this.eventType);
        if (this.properties != null) {
            for (CMNExtendedProperty p : this.properties) {
                if (p == null) continue;
                this.event.getProperties().add((Object)p);
            }
        }
        if (this.annotations != null) {
            for (CMNAnnotation a : this.annotations) {
                if (a == null) continue;
                this.event.getAnnotations().add((Object)a);
            }
        }
        if (this.repositoryRecords != null) {
            TPFExecutionResult exResult = null;
            try {
                ExecutionContext eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
                exResult = eContext.rootResult.getResult();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            for (TPFRepositoryRecord record : this.repositoryRecords) {
                if (record == null) continue;
                this.event.getDefectRecords().add((Object)record);
                if (exResult == null) continue;
                exResult.getRecords().add((Object)record);
            }
        }
        if (this.parentId == null) {
            ExecutionContext eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
            eContext.logEvent(this.event);
        }
    }

    public void addYourselfToContainer() {
        TPFExecutionHistory history;
        ExecutionContext eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
        EObject preRegisteredEventInstance = null;
        if (this.id != null) {
            try {
                preRegisteredEventInstance = eContext.getEObjectByID(this.id);
            }
            catch (Exception exception) {}
            if (preRegisteredEventInstance == null) {
                eContext.putEObjectByID(this.id, this.event);
            }
        }
        if (this.parentId != null && this.parentId.equals(ROOT_PARENT)) {
            TPFExecutionResult exResult = eContext.rootResult.getResult();
            if (exResult != null) {
                history = exResult.getExecutionHistory();
                if (history == null) {
                    history = Common_TestprofileFactoryImpl.eINSTANCE.createTPFExecutionHistory();
                    exResult.setExecutionHistory(history);
                }
                if (!this.insertEvent(history.getExecutionEvents(), this.event)) {
                    this.event.setExecutionHistory(history);
                }
            }
        } else if (this.parentId != null) {
            TPFExecutionEvent parentEvent;
            EObject obj = eContext.getEObjectByID(this.parentId);
            if (obj != null && obj instanceof TPFInvocationEvent) {
                history = ((TPFInvocationEvent)obj).getInvokedExecutionResult().getExecutionHistory();
                if (history != null && !this.insertEvent(history.getExecutionEvents(), this.event)) {
                    this.event.setExecutionHistory(history);
                }
            } else if (obj != null && !this.insertEvent((parentEvent = (TPFExecutionEvent)obj).getChildren(), this.event)) {
                this.event.setParent(parentEvent);
            }
        }
        if (this.parentId != null && this.ownerId != null && this.ownerId.trim().length() != 0) {
            EObject testElement;
            TPFTest theTest = null;
            theTest = this.ownerType != null && this.ownerType.trim().length() > 0 ? this.getProxyReferencedTest() : this.getReferencedTest();
            if (theTest != null && (testElement = this.ownerType != null && this.ownerType.trim().length() > 0 ? ExecutionResultData.getObjectFromTest(theTest, this.ownerId, this.ownerType) : ExecutionResultData.getObjectFromTest(theTest, this.ownerId)) != null && testElement instanceof BVRInteractionFragment) {
                this.event.setInteractionFragment((BVRInteractionFragment)testElement);
            }
        }
        for (CMNAnnotation annotation : this.event.getAnnotations()) {
            if (annotation == null) continue;
            try {
                String annotationURI = annotation.getURI();
                annotation.putFileAnnotation(URI.createFileURI((String)annotationURI));
                File annotationFile = new File(annotationURI);
                if (!annotationFile.exists()) continue;
                annotationFile.delete();
            }
            catch (Exception e) {
                ModelDebugger.log((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TPFTest getProxyReferencedTest() {
        TPFExecutionResult result;
        TPFExecutionHistory history;
        TPFTest referencedTest = null;
        if (this.event != null && (history = this.getContainingHistory(this.event)) != null && (result = history.getExecutionResult()) != null) {
            Object object = ModelTraversalLock;
            synchronized (object) {
                referencedTest = (TPFTest)result.eGet((EStructuralFeature)Common_TestprofilePackage.Literals.TPF_EXECUTION_RESULT__TEST, false);
            }
        }
        return referencedTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TPFTest getReferencedTest() {
        TPFExecutionResult result;
        TPFExecutionHistory history;
        TPFTest referencedTest = null;
        if (this.event != null && (history = this.getContainingHistory(this.event)) != null && (result = history.getExecutionResult()) != null) {
            Object object = ModelTraversalLock;
            synchronized (object) {
                referencedTest = result.getTest();
            }
        }
        return referencedTest;
    }

    private void constructAnnotation() {
        File tempDir = FileUtil.getTempDir();
        try {
            File annotationFile = new File(tempDir, this.annotationFilename);
            FileOutputStream os = new FileOutputStream(annotationFile);
            os.write(XMLTypeFactory.eINSTANCE.createBase64Binary(new String(this.annotationCDATA)));
            os.close();
            URI uri = URI.createFileURI((String)annotationFile.getAbsolutePath());
            this.annotation.setURI(uri.toFileString());
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    private TPFExecutionHistory getContainingHistory(TPFExecutionEvent executionEvent) {
        TPFExecutionHistory history = executionEvent.getExecutionHistory();
        history = executionEvent.getExecutionHistory();
        while (history == null) {
            if ((executionEvent = executionEvent.getParent()) == null) break;
            history = executionEvent.getExecutionHistory();
        }
        return history;
    }

    private EAttribute getSortEAttribute() {
        if (this.sortBy == null) {
            return null;
        }
        EStructuralFeature esf = this.event.eClass().getEStructuralFeature(this.sortBy);
        if (esf == null || !(esf instanceof EAttribute)) {
            return null;
        }
        return (EAttribute)esf;
    }

    private boolean isSortNeeded() {
        if (this.sortBy == null || this.sortBy.length() == 0) {
            return false;
        }
        EAttribute ea = this.getSortEAttribute();
        if (ea == null) {
            return false;
        }
        Object obj = this.event.eGet((EStructuralFeature)ea);
        return obj != null;
    }

    private boolean insertEvent(EList events, TPFExecutionEvent event) {
        if (this.resolveConflict(events)) {
            return true;
        }
        if (!this.isSortNeeded()) {
            return false;
        }
        int index = this.getIndex(events, event);
        if (index >= events.size()) {
            return false;
        }
        events.add(index, (Object)event);
        return true;
    }

    protected boolean resolveConflict(EList events) {
        if (this.conflict == 0) {
            return false;
        }
        if (this.event.getId() == null) {
            return false;
        }
        TPFExecutionEvent match = null;
        for (TPFExecutionEvent ev : events) {
            if (!this.isIdentical(ev)) continue;
            match = ev;
            break;
        }
        if (match == null) {
            return false;
        }
        if (this.needOverwrite(match)) {
            this.overwrite(match);
        }
        this.event = match;
        return true;
    }

    protected boolean isIdentical(TPFExecutionEvent match) {
        return this.event.getId().equals(match.getId()) && this.event.getClass().getName().equals(match.getClass().getName());
    }

    protected boolean needOverwrite(TPFExecutionEvent match) {
        boolean overwrite = false;
        switch (this.conflict) {
            case 1: {
                break;
            }
            case 2: {
                overwrite = true;
                break;
            }
            case 3: {
                if (this.event.getTimestamp() >= match.getTimestamp()) break;
                overwrite = true;
                break;
            }
            case 4: {
                if (this.event.getTimestamp() <= match.getTimestamp()) break;
                overwrite = true;
                break;
            }
            default: {
                return false;
            }
        }
        return overwrite;
    }

    protected void overwrite(TPFExecutionEvent match) {
        match.setTimestamp(this.event.getTimestamp());
        match.setText(this.event.getText());
        match.setEventType(this.event.getEventType());
        match.setName(this.event.getName());
        match.setInteractionFragment(this.event.getInteractionFragment());
        match.setOwnerId(this.event.getOwnerId());
        match.getProperties().clear();
        match.getProperties().addAll((Collection)this.properties);
        match.getDefectRecords().clear();
        match.getDefectRecords().addAll((Collection)this.repositoryRecords);
    }

    private int getIndex(EList events, TPFExecutionEvent event) {
        EAttribute ea = (EAttribute)event.eClass().getEStructuralFeature(this.sortBy);
        String newValue = event.eGet((EStructuralFeature)ea).toString();
        int index = 0;
        Object obj = null;
        index = 0;
        while (index < events.size()) {
            String val;
            TPFExecutionEvent ev = (TPFExecutionEvent)events.get(index);
            obj = ev.eGet((EStructuralFeature)ea);
            if (obj != null && (val = obj.toString()).compareTo(newValue) > 0) break;
            ++index;
        }
        return index;
    }

    protected void printTag(String str) {
    }

    protected void printAttribute(String name, String value) {
    }

    protected void printEndTag() {
    }
}

