/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common.provisional;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class TestlogFilenameExtensionManager {
    private static TestlogFilenameExtensionManager instance = null;
    private static String IID = "org.eclipse.tptp.platform.models.testlog_filename_extension";
    private static String EXT_VAL_ATTRIBUTE = "value";
    private static String TEST_TYPE_ELEMENT_NAME = "testtype";
    private static String TEST_TYPE_NAME_ATTRIBUTE = "name";
    private IConfigurationElement[] testLogFilenameExtensions = null;
    private HashMap extensionMap = new HashMap();
    private static final boolean DISABLE_CUSTOM_EXTENSIONS = System.getProperty("tptpDisableCustomTestLogExtensions") != null && System.getProperty("tptpDisableCustomTestLogExtensions").equals("true");

    private TestlogFilenameExtensionManager() {
        this.testLogFilenameExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(IID);
        if (!DISABLE_CUSTOM_EXTENSIONS) {
            int i = 0;
            while (i < this.testLogFilenameExtensions.length) {
                IConfigurationElement providedExtension = this.testLogFilenameExtensions[i];
                String extension = providedExtension.getAttribute(EXT_VAL_ATTRIBUTE);
                IConfigurationElement[] testTypes = providedExtension.getChildren(TEST_TYPE_ELEMENT_NAME);
                int j = 0;
                while (j < testTypes.length) {
                    IConfigurationElement testType = testTypes[j];
                    String testTypeName = testType.getAttribute(TEST_TYPE_NAME_ATTRIBUTE);
                    this.extensionMap.put(testTypeName, extension);
                    ++j;
                }
                ++i;
            }
        }
    }

    public static TestlogFilenameExtensionManager getInstance() {
        if (instance == null) {
            instance = new TestlogFilenameExtensionManager();
        }
        return instance;
    }

    public String getExtensionForTestType(String testType) {
        return (String)this.extensionMap.get(testType);
    }

    public String[] getAllRegisteredLogExtensions() {
        if (this.extensionMap.values().size() > 0) {
            HashSet set = new HashSet(this.extensionMap.values());
            return set.toArray(new String[0]);
        }
        return null;
    }
}

