/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common.provisional;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.hyades.loaders.common.XMLmessageEventLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CommonFactory;
import org.eclipse.hyades.models.common.util.FileUtil;
import org.eclipse.hyades.models.util.ModelDebugger;

public class XMLannotatedMessageEventLoader
extends XMLmessageEventLoader {
    protected static final String EVENT_ANNOTATION = "annotation";
    protected static final String EVENT_ANNOTATION_FILENAME = "annotationFilename";
    protected static final String EVENT_ANNOTATION_TYPE = "annotationType";
    protected static final int EVENT_ANNOTATION_int = -1555043537;
    protected static final int EVENT_ANNOTATION_FILENAME_int = 35807592;
    protected static final int EVENT_ANNOTATION_TYPE_int = 93157147;
    protected CMNAnnotation annotation = null;
    protected String annotationFilename = null;
    protected char[] annotationCDATA = null;
    protected ArrayList annotations = new ArrayList();

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.annotation = null;
        this.annotationFilename = null;
        this.annotationCDATA = null;
        this.annotations.clear();
    }

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 35807592: {
                if (this.annotation == null) break;
                this.annotationFilename = value;
                break;
            }
            case 93157147: {
                if (this.annotation == null) break;
                this.annotation.setType(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
        if (this.annotation != null) {
            if (this.annotationCDATA == null) {
                this.annotationCDATA = new char[length];
                System.arraycopy(data, offset, this.annotationCDATA, 0, length);
            } else {
                int size = this.annotationCDATA.length + length;
                char[] newData = new char[size];
                System.arraycopy(this.annotationCDATA, 0, newData, 0, this.annotationCDATA.length);
                System.arraycopy(data, offset, newData, this.annotationCDATA.length, length);
                this.annotationCDATA = newData;
                newData = null;
            }
        }
    }

    public void startChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -1555043537: {
                this.annotation = CommonFactory.eINSTANCE.createCMNAnnotation();
                break;
            }
            default: {
                super.startChild(name);
            }
        }
        super.startChild(name);
    }

    public void endChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -1555043537: {
                this.constructAnnotation();
                this.annotations.add(this.annotation);
                this.annotation = null;
                this.annotationFilename = null;
                this.annotationCDATA = null;
                break;
            }
            default: {
                super.endChild(name);
            }
        }
    }

    private void constructAnnotation() {
        File tempDir = FileUtil.getTempDir();
        try {
            File annotationFile = new File(tempDir, this.annotationFilename);
            FileOutputStream os = new FileOutputStream(annotationFile);
            os.write(XMLTypeFactory.eINSTANCE.createBase64Binary(new String(this.annotationCDATA)));
            os.close();
            URI uri = URI.createFileURI((String)annotationFile.getAbsolutePath());
            this.annotation.setURI(uri.toFileString());
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    public void addYourselfInContext() {
        super.addYourselfInContext();
        if (this.annotations != null) {
            for (CMNAnnotation a : this.annotations) {
                if (a == null) continue;
                this.event.getAnnotations().add((Object)a);
                try {
                    String uri = a.getURI();
                    a.putFileAnnotation(URI.createFileURI((String)uri));
                    File file = new File(uri);
                    if (!file.exists()) continue;
                    file.delete();
                }
                catch (Exception e) {
                    ModelDebugger.log((Throwable)e);
                }
            }
        }
    }
}

