/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.statistical;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.hyades.loaders.statistical.SnapshotObservationBase;
import org.eclipse.hyades.loaders.statistical.StatisticalLookupService;
import org.eclipse.hyades.loaders.statistical.StatisticalXMLLoadersFactory;
import org.eclipse.hyades.loaders.statistical.XMLContiguousObservationLoader;
import org.eclipse.hyades.loaders.statistical.XMLCounterDescriptorLoader;
import org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader;
import org.eclipse.hyades.loaders.statistical.XMLDiscreteObservationLoader;
import org.eclipse.hyades.loaders.statistical.XMLSampleDescriptorLoader;
import org.eclipse.hyades.loaders.statistical.XMLTextObservationLoader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupService;
import org.eclipse.hyades.models.util.ModelDebugger;

public class GenerateConstants {
    protected static Class[] classes = new Class[]{StatisticalXMLLoadersFactory.class, XMLDescriptorLoader.class, XMLSampleDescriptorLoader.class, XMLCounterDescriptorLoader.class, XMLDiscreteObservationLoader.class, XMLContiguousObservationLoader.class, XMLTextObservationLoader.class, SnapshotObservationBase.class};
    protected static Class[] lookUpServiceClasses = new Class[]{StatisticalLookupService.class};

    public static void main(String[] args) {
        GenerateConstants generateConstants = new GenerateConstants();
        generateConstants.processClasses();
    }

    protected void processClasses() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < classes.length) {
            this.addFieldsName(classes[i], list);
            ++i;
        }
        i = 0;
        while (i < lookUpServiceClasses.length) {
            this.addLookUpServiceName(lookUpServiceClasses[i], list);
            ++i;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String[])o1)[0].compareTo(((String[])o2)[0]);
            }
        });
        try {
            PrintWriter out = new PrintWriter(new FileWriter("E:\\workspaces\\hyades-4.1-i1\\org.eclipse.tptp.platform.models\\src-statistical\\org\\eclipse\\hyades\\loaders\\statistical\\StatisticalConstants.java"));
            out.println("/**********************************************************************\n * Copyright (c) 2003, 2006 IBM Corporation and others.\n * All rights reserved.   This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n *\n * Contributors:\n * IBM - Initial API and implementation\n **********************************************************************/\npackage org.eclipse.hyades.loaders.statistical;\n\n/**\n * @author slavescu\n */\npublic class StatisticalConstants {\n");
            for (String[] field : list) {
                out.println("\tprotected static final int " + field[0] + "_int = " + LoadersUtils.getHashCode((String)field[1]) + ";");
            }
            out.println("}\n");
            out.close();
        }
        catch (IOException e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    protected void addLookUpServiceName(Class class1, List list) {
        try {
            LookupService lookupService = (LookupService)class1.newInstance();
            for (Class element : lookupService.getSupportedTypes()) {
                String name = element.getName();
                if (name.lastIndexOf(46) > 0) {
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                list.add(new String[]{name, element.getName()});
            }
        }
        catch (InstantiationException e) {
            ModelDebugger.log((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    protected void addFieldsName(Class theClass, List list) {
        try {
            Field[] fields = theClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Object value;
                int mod = fields[i].getModifiers();
                if (Modifier.isProtected(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && fields[i].getType() == String.class && (value = fields[i].get(null)) != null) {
                    list.add(new String[]{fields[i].getName(), value.toString()});
                }
                ++i;
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }
}

