/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.statistical;

import org.eclipse.hyades.loaders.statistical.XMLDescriptorLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRangeRepresentation;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

public class XMLCounterDescriptorLoader
extends XMLDescriptorLoader {
    protected static final String GaugeRepresentation = "GaugeRepresentation";
    protected static final String RangeRepresentation = "RangeRepresentation";
    protected static final String TextRepresentation = "TextRepresentation";
    protected static final String DiscreteRepresentation = "DiscreteRepresentation";
    protected static final String ContiguousRepresentation = "ContiguousRepresentation";
    protected static final String min = "min";
    protected static final String max = "max";
    protected static final String minThreshold = "minThreshold";
    protected static final String maxThreshold = "maxThreshold";
    protected SDRepresentation representation;

    public void addYourselfInContext() {
        SDCounterDescriptor descriptor = (SDCounterDescriptor)LookupServiceExtensions.getInstance().locate(this.context, SDDescriptor.class, (Object)this.fId);
        if (descriptor == null) {
            descriptor = StatisticalFactory.eINSTANCE.createSDCounterDescriptor();
            descriptor.setId(this.fId);
            if (this.fName != null) {
                descriptor.setName(this.fName);
            }
            LoadersUtils.getOrCreateAgent((HierarchyContext)this.context).getDescriptor().add((Object)descriptor);
        }
        this.updateAttributes(descriptor);
    }

    public void startChild(String name) {
        if (this.localDepth == 0) {
            switch (LoadersUtils.getHashCode((String)name)) {
                case 884119046: {
                    this.representation = StatisticalFactory.eINSTANCE.createSDGaugeRepresentation();
                    ++this.localDepth;
                    break;
                }
                case -698370230: {
                    this.representation = StatisticalFactory.eINSTANCE.createSDRangeRepresentation();
                    ++this.localDepth;
                    break;
                }
                case 1660294010: {
                    this.representation = StatisticalFactory.eINSTANCE.createSDTextRepresentation();
                    ++this.localDepth;
                    break;
                }
                case 516243526: {
                    this.representation = StatisticalFactory.eINSTANCE.createSDDiscreteRepresentation();
                    ++this.localDepth;
                    break;
                }
                case -441009052: {
                    this.representation = StatisticalFactory.eINSTANCE.createSDContiguousRepresentation();
                    ++this.localDepth;
                    break;
                }
                default: {
                    super.startChild(name);
                }
            }
        }
    }

    public void endChild(String name) {
        super.endChild(name);
        if (this.localDepth == 1) {
            --this.localDepth;
        }
    }

    protected void updateAttributes(SDMemberDescriptor descriptor) {
        super.updateAttributes(descriptor);
        if (this.representation != null) {
            descriptor.setRepresentation(this.representation);
        }
    }

    public void addAttribute(String name, String value) {
        if (this.localDepth == 1 && this.representation != null) {
            switch (LoadersUtils.getHashCode((String)name)) {
                case 108114: {
                    ((SDRangeRepresentation)this.representation).setMin(Integer.parseInt(value));
                    break;
                }
                case 107876: {
                    ((SDRangeRepresentation)this.representation).setMax(Integer.parseInt(value));
                    break;
                }
                case 1800624697: {
                    ((SDGaugeRepresentation)this.representation).setMinThreshold(Integer.parseInt(value));
                    break;
                }
                case 1326198631: {
                    ((SDGaugeRepresentation)this.representation).setMaxThreshold(Integer.parseInt(value));
                    break;
                }
                default: {
                    super.addAttribute(name, value);
                }
            }
            return;
        }
        super.addAttribute(name, value);
    }

    public void initialize(HierarchyContext context, String elementName) {
        super.initialize(context, elementName);
        this.representation = null;
    }
}

