/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.statistical;

import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

public class XMLDescriptorLoader
extends IgnoredXMLFragmentLoader {
    protected String fId;
    protected String fParent;
    protected StringBuffer fDescription = new StringBuffer();
    protected String fName;
    protected static final String id = "id";
    protected static final String parent = "parent";
    protected static final String name = "name";
    protected static final String description = "description";
    protected int localDepth;

    public void initialize(HierarchyContext context, String elementName) {
        super.initialize(context, elementName);
        this.fId = null;
        this.fParent = null;
        this.fName = null;
        this.fDescription.setLength(0);
        this.localDepth = 0;
    }

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3355: {
                this.fId = value;
                break;
            }
            case -995424086: {
                this.fParent = value;
                break;
            }
            case 3373707: {
                this.fName = value;
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void startChild(String name) {
        if (this.localDepth == 0 && name.equals(description)) {
            ++this.localDepth;
        }
    }

    public void endChild(String name) {
        if (this.localDepth == 1 && name.equals(description)) {
            --this.localDepth;
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
        if (this.localDepth == 1) {
            this.fDescription.append(data, offset, length);
        }
    }

    public void addYourselfInContext() {
        SDDescriptor descriptor = (SDDescriptor)LookupServiceExtensions.getInstance().locate(this.context, SDDescriptor.class, (Object)this.fId);
        if (descriptor == null) {
            descriptor = StatisticalFactory.eINSTANCE.createSDDescriptor();
            descriptor.setId(this.fId);
        }
        this.updateAttributes(descriptor);
    }

    protected void updateAttributes(SDDescriptor descriptor) {
        if (descriptor.getName() == null) {
            descriptor.setName(this.fName);
        }
        descriptor.setDescription(this.fDescription.toString());
        if (this.fParent != null && descriptor.getParent() == null) {
            SDDescriptor parentDescriptor = (SDDescriptor)LookupServiceExtensions.getInstance().locate(this.context, SDDescriptor.class, (Object)this.fParent);
            if (parentDescriptor != null) {
                descriptor.setParent(parentDescriptor);
            } else if (descriptor.eContainer() == null) {
                LoadersUtils.getOrCreateAgent((HierarchyContext)this.context).getDescriptor().add((Object)descriptor);
            }
        } else if (descriptor.eContainer() == null) {
            LoadersUtils.getOrCreateAgent((HierarchyContext)this.context).getDescriptor().add((Object)descriptor);
        }
    }
}

