/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Map;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TRCObjectEntry;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.ExtendedLookupService;
import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.util.IntToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.LongToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.internal.IntToObjectMapImpl;
import org.eclipse.hyades.models.hierarchy.util.internal.LongToObjectMapImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.models.trace.impl.TRCProcessImpl;
import org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;

public class TraceLookupService
extends GenericLookupService
implements ExtendedLookupService {
    private static final long serialVersionUID = 3691040963154031927L;

    public TraceLookupService() {
        this.types.add(TRCProcessImpl.class);
        this.types.add(TRCThreadImpl.class);
        this.types.add(TRCPackageImpl.class);
        this.types.add(TRCClassImpl.class);
        this.types.add(TRCClass.class);
        this.types.add(TRCArrayClassImpl.class);
        this.types.add(TRCMethodImpl.class);
        this.types.add(TRCMethodWithLLDataImpl.class);
        this.types.add(TRCMethod.class);
        this.types.add(TRCHeapDumpImpl.class);
        this.types.add(TRCObjectEntry.class);
        this.types.add(TRCHeapObjectImpl.class);
        this.types.add(TRCFullTraceObjectImpl.class);
        this.types.add(TRCFullHeapObjectImpl.class);
        this.types.add(VirtualObjectInfo.class);
        this.types.add(TRCSourceInfoImpl.class);
        this.types.add(TRCSourceInfo.class);
        this.types.add(TRCFullMethodInvocationImpl.class);
        this.types.add(CallStackPerThread.class);
    }

    public boolean deregister(HierarchyContext context, Class type, Object key) {
        if (this.isObjectType(type)) {
            Map typeMap = this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return false;
            }
            TRCObjectEntry objectEntry = (TRCObjectEntry)typeMap.get(key);
            if (objectEntry == null) {
                return false;
            }
            return objectEntry.remove(type);
        }
        return super.deregister(context, type, key);
    }

    public boolean deregister(HierarchyContext context, Class type) {
        if (this.isObjectType(type)) {
            Map typeMap = this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return false;
            }
            boolean ret = false;
            for (TRCObjectEntry objectEntry : typeMap.values()) {
                if (!objectEntry.remove(type)) continue;
                ret = true;
            }
            return ret;
        }
        return super.deregister(context, type);
    }

    protected boolean isObjectType(Class type) {
        return type == TRCHeapObjectImpl.class || type == TRCFullTraceObjectImpl.class || type == TRCFullHeapObjectImpl.class;
    }

    public Object locate(HierarchyContext context, Class type, Object key) {
        if (this.isObjectType(type)) {
            Map typeMap = this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return null;
            }
            TRCObjectEntry objectEntry = (TRCObjectEntry)typeMap.get(key);
            if (objectEntry == null) {
                return null;
            }
            return objectEntry.get(type);
        }
        return super.locate(context, this.getEquivalentClass(type), key);
    }

    protected Class getEquivalentClass(Class type) {
        if (TRCFullMethodInvocation.class.isAssignableFrom(type)) {
            return TRCFullMethodInvocationImpl.class;
        }
        if (TRCMethod.class.isAssignableFrom(type)) {
            return TRCMethod.class;
        }
        if (TRCClass.class.isAssignableFrom(type)) {
            return TRCClass.class;
        }
        if (TRCSourceInfo.class.isAssignableFrom(type)) {
            return TRCSourceInfo.class;
        }
        return type;
    }

    protected Map getTypeMap(HierarchyContext context, Class type, boolean create) {
        if (this.isObjectType(type)) {
            return super.getTypeMap(context, TRCObjectEntry.class, create);
        }
        return super.getTypeMap(context, this.getEquivalentClass(type), create);
    }

    protected Map createMap(Class equivalentType) {
        int classNameInt = LoadersUtils.getHashCode((String)equivalentType.getName());
        switch (classNameInt) {
            case -447284631: {
                return new IntToObjectMapImpl();
            }
            case 73481062: {
                return new IntToObjectMapImpl();
            }
            case -912353741: {
                return new IntToObjectMapImpl();
            }
            case -1631928251: {
                return new LongToObjectMapImpl();
            }
            case 1230214068: {
                return new IntToObjectMapImpl();
            }
            case -506323084: 
            case -116543028: 
            case 320375651: {
                return new LongToObjectMapImpl();
            }
            case -541378176: {
                return new LongToObjectMapImpl();
            }
            case 1916132540: {
                return new IntToObjectMapImpl();
            }
            case -475058967: {
                return new IntToObjectMapImpl();
            }
            case 688917711: {
                return new IntToObjectMapImpl();
            }
            case -285893434: {
                return new LongToObjectMapImpl();
            }
        }
        return super.createMap(equivalentType);
    }

    protected boolean doProcessObject(Map typeMap, Class type, Object object, boolean remove) {
        if (object == null) {
            return false;
        }
        int classNameInt = LoadersUtils.getHashCode((String)this.getEquivalentClass(type).getName());
        switch (classNameInt) {
            case -447284631: {
                TRCFullMethodInvocation inv = (TRCFullMethodInvocation)object;
                if (inv.getThread() == null) {
                    return false;
                }
                LongToObjectMap ticketsMap = (LongToObjectMap)((IntToObjectMap)typeMap).get(inv.getThread().getId());
                if (ticketsMap == null) {
                    ticketsMap = new LongToObjectMapImpl();
                    ((IntToObjectMap)typeMap).put(inv.getThread().getId(), (Object)ticketsMap);
                }
                this.addOrRemove(ticketsMap, inv.getTicket(), object, remove);
                return true;
            }
            case 73481062: {
                this.addOrRemove((IntToObjectMap)typeMap, LoadersUtils.getHashCode((String)((TRCProcess)object).getId()), object, remove);
                return true;
            }
            case -912353741: {
                this.addOrRemove((IntToObjectMap)typeMap, ((TRCThread)object).getId(), object, remove);
                return true;
            }
            case 779914685: {
                this.addOrRemove(typeMap, ((TRCPackage)object).getName(), object, remove);
                return true;
            }
            case -1631928251: {
                this.addOrRemove((LongToObjectMap)typeMap, ((TRCClass)object).getId(), object, remove);
                return true;
            }
            case 1230214068: {
                this.addOrRemove((IntToObjectMap)typeMap, ((TRCMethod)object).getId(), object, remove);
                return true;
            }
            case -506323084: 
            case -116543028: 
            case 320375651: {
                long key = ((TRCObject)object).getId();
                TRCObjectEntry objectEntry = (TRCObjectEntry)((LongToObjectMap)typeMap).get(key);
                if (objectEntry == null) {
                    objectEntry = new TRCObjectEntry();
                    this.addOrRemove((LongToObjectMap)typeMap, key, objectEntry, remove);
                }
                objectEntry.put(type, (TRCObject)object);
                return true;
            }
            case -541378176: {
                this.addOrRemove((LongToObjectMap)typeMap, ((TRCObjectEntry)object).getId(), object, remove);
                return true;
            }
            case 1916132540: {
                this.addOrRemove((IntToObjectMap)typeMap, LoadersUtils.getHashCode((String)((TRCSourceInfo)object).getLocation()), object, remove);
                return true;
            }
            case -475058967: {
                this.addOrRemove((IntToObjectMap)typeMap, ((TRCHeapDump)object).getId(), object, remove);
                return true;
            }
        }
        return false;
    }

    public boolean deregister(HierarchyContext context, Class type, int key) {
        if (this.isObjectType(type)) {
            IntToObjectMap typeMap = (IntToObjectMap)this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return false;
            }
            TRCObjectEntry objectEntry = (TRCObjectEntry)typeMap.get(key);
            if (objectEntry == null) {
                return false;
            }
            return objectEntry.remove(type);
        }
        IntToObjectMap typeMap = (IntToObjectMap)this.getTypeMap(context, this.getEquivalentClass(type), false);
        if (typeMap == null) {
            return false;
        }
        typeMap.remove(key);
        return true;
    }

    public boolean deregister(HierarchyContext context, Class type, long key) {
        if (this.isObjectType(type)) {
            LongToObjectMap typeMap = (LongToObjectMap)this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return false;
            }
            TRCObjectEntry objectEntry = (TRCObjectEntry)typeMap.get(key);
            if (objectEntry == null) {
                return false;
            }
            return objectEntry.remove(type);
        }
        LongToObjectMap typeMap = (LongToObjectMap)this.getTypeMap(context, this.getEquivalentClass(type), false);
        if (typeMap == null) {
            return false;
        }
        typeMap.remove(key);
        return true;
    }

    public Object locate(HierarchyContext context, Class type, int key) {
        if (this.isObjectType(type)) {
            IntToObjectMap typeMap = (IntToObjectMap)this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return null;
            }
            TRCObjectEntry objectEntry = (TRCObjectEntry)typeMap.get(key);
            if (objectEntry == null) {
                return null;
            }
            return objectEntry.get(type);
        }
        IntToObjectMap typeMap = (IntToObjectMap)this.getTypeMap(context, this.getEquivalentClass(type), false);
        if (typeMap == null) {
            return null;
        }
        return typeMap.get(key);
    }

    public Object locate(HierarchyContext context, Class type, long key) {
        if (this.isObjectType(type)) {
            LongToObjectMap typeMap = (LongToObjectMap)this.getTypeMap(context, TRCObjectEntry.class, false);
            if (typeMap == null) {
                return null;
            }
            TRCObjectEntry objectEntry = (TRCObjectEntry)typeMap.get(key);
            if (objectEntry == null) {
                return null;
            }
            return objectEntry.get(type);
        }
        LongToObjectMap typeMap = (LongToObjectMap)this.getTypeMap(context, this.getEquivalentClass(type), false);
        if (typeMap == null) {
            return null;
        }
        return typeMap.get(key);
    }
}

