/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.trace.ThreadEventsContext;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl;

public class TraceXMLThreadEventsLoader
extends TraceXMLFragmentLoader {
    private final double TIME_THRESHOLD = 0.1;

    protected ThreadEventsContext getThreadEventsContext() {
        ThreadEventsContext threadEventsContext = (ThreadEventsContext)this.context.getCustomData().get(ThreadEventsContext.class);
        if (threadEventsContext == null) {
            threadEventsContext = new ThreadEventsContext();
            this.context.getCustomData().put(ThreadEventsContext.class, threadEventsContext);
        }
        return threadEventsContext;
    }

    protected boolean canEventsBeBound(TRCThreadEvent runningEvent, TRCThreadEvent interactionEvent) {
        return runningEvent.getTime() + 0.1 > interactionEvent.getTime();
    }

    protected void addInteractionEvent(TRCThread thread, TRCThreadExecEvent execEvent) {
        int lastEventIndex = thread.getThreadEvents().size() - 1;
        TRCThreadEvent lastEvent = null;
        if (lastEventIndex < 0) {
            return;
        }
        lastEvent = (TRCThreadEvent)thread.getThreadEvents().get(lastEventIndex);
        if (lastEvent instanceof TRCThreadRunningEvent) {
            TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
            runningEvent.setTime(execEvent.getTime());
            runningEvent.setThread(execEvent.getThread());
            thread.getThreadEvents().add((Object)execEvent);
            thread.getThreadEvents().add((Object)runningEvent);
        } else if (lastEvent instanceof TRCThreadWaitingForObjectEvent || lastEvent instanceof TRCThreadWaitingForLockEvent || lastEvent instanceof TRCThreadWaitingForJoinEvent || lastEvent instanceof TRCThreadDeadEvent || lastEvent instanceof TRCThreadSleepingEventImpl) {
            execEvent.setTime(lastEvent.getTime());
            thread.getThreadEvents().add(lastEventIndex, (Object)execEvent);
        }
    }

    protected TRCThreadEvent getLastEventForThread(TRCThread thread) {
        int lastIndex = thread.getThreadEvents().size() - 1;
        TRCThreadEvent lastEvent = null;
        if (lastIndex >= 0) {
            lastEvent = (TRCThreadEvent)thread.getThreadEvents().get(lastIndex);
        }
        return lastEvent;
    }

    protected void processEF(int step) {
        super.processEF(step);
        if (this.theObject == null || !(this.theObject instanceof TRCFullTraceObject)) {
            this.theObject = (TRCFullTraceObject)LookupServiceExtensions.getInstance().locate(this.context, TRCFullTraceObjectImpl.class, this.objIdRef);
        }
    }
}

