/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;

public class XMLmethodCallLoader
extends TraceMethodBaseLoader {
    private static final Object REMOTE_INVOCATION_RESOLUTION_LOCK = new Object();

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodIdRef))) {
            return;
        }
        if (this.remoteInvocationContext) {
            this.activeInvocationContext = true;
        }
        this.theProcess = this.getProcess();
        this.theThread = this.getThreadByIdRef(this.theProcess);
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, CallStackPerThread.class, this.threadIdRef);
        if (this.cs == null) {
            Object csKey = LoadersUtils.getLookUpKey((int)this.threadIdRef);
            this.cs = new CallStackPerThread();
            LoadersUtils.registerGenericLookUpEntry((HierarchyContext)this.context, (Object)csKey, (Object)this.cs);
        }
        this.invocationPool = this.cs.invocationPool;
        this.dispatchProcessMode(0);
        this.setMaxStackDepth(this.theThread);
    }

    public void cleanUp(HierarchyContext context) {
        LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
        super.cleanUp();
    }

    public void endChild(String name) {
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(context, name);
        this.fullInvoker = null;
    }

    public void startChild(String name) {
        if (!this.loadToModel) {
            return;
        }
        if (name.equals("InvocationContext")) {
            this.setNullInvocationContext();
            this.activeInvocationContext = true;
        } else {
            super.startChild(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEF(int step) {
        super.processEF(step);
        this.theClass = this.getClassByIdRef(this.theThread, TRCFullTraceObjectImpl.class, 0);
        this.theMethod = this.getMethodByIdRef(this.theClass);
        if (this.createClassObjects) {
            this.theObject = this.objIdRef > 0L ? this.getObjectByIdRef(this.objIdRef, TRCFullTraceObjectImpl.class) : this.getClassObject(this.theMethod.getDefiningClass(), TRCFullTraceObjectImpl.class);
            if (this.theObject == null) {
                this.theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
            }
        }
        this.fullInvocation = TraceFactory.eINSTANCE.createTRCCallerCalleeInvocationInfo();
        this.fullInvocation.setStackDepth(this.stackDepth);
        ((TRCCallerCalleeInvocationInfo)this.fullInvocation).setCallTime(this.createDeltaTime());
        this.fullInvocation.setTicket(this.ticket);
        this.fullInvocation.setMethod(this.theMethod);
        this.fullInvocation.setThread(this.theThread);
        this.fullInvocation.setProcess(this.theProcess);
        this.fullInvocation.setOwningObject((TRCFullTraceObject)this.theObject);
        this.addInputOutputValues();
        Object object = REMOTE_INVOCATION_RESOLUTION_LOCK;
        synchronized (object) {
            this.setInvokerMethod(this.theThread, this.fullInvocation);
            this.updateForwardInvokes(this.fullInvocation);
        }
        if (this.cs.isEmpty()) {
            this.theThread.getInitialInvocations().add((Object)this.fullInvocation);
        }
        this.cs.push(this.invocationPool.allocInvocation(this.fullInvocation, this.cs));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processES(int step) {
        super.processES(step);
        this.theClass = this.getClassByIdRef(this.theThread, TRCFullTraceObjectImpl.class, 0);
        this.theMethod = this.getMethodByIdRef(this.theClass);
        if (!this.createClassObjects) return;
        if (this.objIdRef > 0L) {
            this.virtualObject = (VirtualObjectInfo)LookupServiceExtensions.getInstance().locate(this.context, VirtualObjectInfo.class, this.objIdRef);
            if (this.virtualObject == null) return;
            this.theObject = this.getClassObject(this.virtualObject.myClass, TRCFullTraceObjectImpl.class);
            return;
        } else {
            this.theObject = this.getClassObject(this.theClass, TRCFullTraceObjectImpl.class);
        }
    }
}

