/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;

public class XMLmethodInvocationsLoader
extends TraceXMLFragmentLoader {
    protected static final String MIN_VALUE = "minValue";
    protected static final String MAX_VALUE = "maxValue";
    protected static final String MIN_TIME = "minTime";
    protected static final String MAX_TIME = "maxTime";
    protected static final String TOTAL_TIME = "totalTime";
    protected static final String COUNT = "count";
    protected double minTime;
    protected double maxTime;
    protected double totalTime;
    protected int count;
    protected TRCAggregatedMethodInvocation invocation;

    public void addAttribute(String name, String value) {
        if (!this.loadToModel) {
            return;
        }
        switch (LoadersUtils.getHashCode((String)name)) {
            case -1376969153: 
            case 1063908415: {
                this.minTime = Double.parseDouble(value);
                break;
            }
            case 399227501: 
            case 844110417: {
                this.maxTime = Double.parseDouble(value);
                break;
            }
            case -577281999: {
                this.totalTime = Double.parseDouble(value);
                break;
            }
            case 94851343: {
                this.count = Integer.parseInt(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodIdRef))) {
            return;
        }
        if (!this.loadToModel) {
            return;
        }
        this.theProcess = this.getProcess();
        Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
        this.theMethod = (TRCMethod)LookupServiceExtensions.getInstance().locate(this.context, clazz, this.methodIdRef);
        if (this.theMethod == null) {
            return;
        }
        if (this.maxTime != 0.0) {
            this.getAggregatedInvocation().setMaxTime(this.maxTime);
        }
        if (this.minTime != 0.0) {
            this.getAggregatedInvocation().setMinTime(this.minTime);
        }
        if (this.totalTime != 0.0) {
            this.theMethod.setCumulativeTime(this.theMethod.getCumulativeTime() + this.totalTime);
            this.theMethod.getDefiningClass().setCumulativeTime(this.theMethod.getDefiningClass().getCumulativeTime() + this.totalTime);
            this.theMethod.getDefiningClass().getPackage().setCumulativeTime(this.theMethod.getDefiningClass().getPackage().getCumulativeTime() + this.totalTime);
            this.theProcess.setCumulativeTime(this.theProcess.getCumulativeTime() + this.totalTime);
            if (this.invocation != null) {
                this.invocation.setCumulativeTime(this.totalTime);
            }
        }
        if (this.count != 0) {
            if (this.invocation != null) {
                this.theMethod.setCalls(this.theMethod.getCalls() + this.count);
                this.theMethod.getDefiningClass().setCalls(this.theMethod.getDefiningClass().getCalls() + this.count);
                this.theMethod.getDefiningClass().getPackage().setCalls(this.theMethod.getDefiningClass().getPackage().getCalls() + this.count);
                this.theProcess.setCalls(this.theProcess.getCalls() + this.count);
                this.invocation.setCount(this.count);
            } else if (this.count > this.theMethod.getCalls()) {
                this.theMethod.setCalls(this.count);
                this.theMethod.getDefiningClass().setCalls(this.theMethod.getDefiningClass().getCalls() + this.count);
                this.theMethod.getDefiningClass().getPackage().setCalls(this.theMethod.getDefiningClass().getPackage().getCalls() + this.count);
                this.theProcess.setCalls(this.theProcess.getCalls() + this.count);
            }
        }
    }

    protected TRCAggregatedMethodInvocation getAggregatedInvocation() {
        if (this.invocation != null) {
            return this.invocation;
        }
        for (TRCMethodInvocation element : this.theMethod.getInvocations()) {
            if (!(element instanceof TRCAggregatedMethodInvocation)) continue;
            this.invocation = (TRCAggregatedMethodInvocation)element;
            break;
        }
        if (this.invocation == null) {
            this.invocation = TraceFactory.eINSTANCE.createTRCAggregatedMethodInvocation();
            this.theMethod.getInvocations().add((Object)this.invocation);
            this.theProcess.getInvocations().add((Object)this.invocation);
        }
        return this.invocation;
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(context, name);
        this.minTime = 0.0;
        this.maxTime = 0.0;
        this.totalTime = 0.0;
        this.count = 0;
        this.invocation = null;
    }
}

