/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;

public class XMLobjAllocLoader
extends TraceXMLFragmentLoader {
    protected static final String SIZE = "size";
    protected static final String IS_ARRAY = "isArray";
    protected static final String OBJ_ID = "objId";
    protected static final String A_METHOD_ID_REF = "aMethodIdRef";
    protected static final String A_CLASS_ID_REF = "aClassIdRef";
    protected static final String A_LINE_NR = "aLineNr";
    protected int isArray;
    protected int size;
    protected int aMethodIdRef;
    protected int aLineNr;
    protected long objId;
    protected long aClassIdRef;
    protected short firstSeenIndex;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 105534578: {
                this.objId = Long.parseLong(value);
                break;
            }
            case 2054496079: {
                this.isArray = Integer.parseInt(value);
                break;
            }
            case 3530753: {
                this.size = Integer.parseInt(value);
                break;
            }
            case -2147184057: {
                this.firstSeenIndex = Short.parseShort(value);
                break;
            }
            case 356208118: {
                this.aMethodIdRef = Integer.parseInt(value);
                break;
            }
            case -823229919: {
                this.aClassIdRef = Long.parseLong(value);
                break;
            }
            case -1830294375: {
                this.aLineNr = Integer.parseInt(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        TRCClass allocClass;
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCClass_Name(), LoadersUtils.getLookUpKey((long)this.classIdRef))) {
            return;
        }
        if (!this.loadToModel) {
            if (this.objId >= 0L) {
                this.theProcess = this.getProcess();
                this.theThread = this.getThreadByIdRef(this.theProcess);
                this.updateTheClass(TRCHeapObjectImpl.class);
                this.updateVirtualObject(this.objId, this.size);
            }
            return;
        }
        this.createTRCObject();
        if (this.aMethodIdRef > 0) {
            TRCClass allocClass2;
            Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
            TRCMethod allocMethod = (TRCMethod)LookupServiceExtensions.getInstance().locate(this.context, clazz, this.aMethodIdRef);
            if (allocMethod != null) {
                this.addAllocAnnotation(allocMethod);
            } else if (this.aClassIdRef > 0L && (allocClass2 = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.aClassIdRef)) != null) {
                this.addAllocAnnotation(allocClass2);
            }
        } else if (this.aClassIdRef > 0L && (allocClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.aClassIdRef)) != null) {
            this.addAllocAnnotation(allocClass);
        }
    }

    private void addAllocAnnotation(TRCMethod allocMethod) {
        TRCObjectAllocationAnnotation allocationAnnotation = this.createAllocAnnotation();
        allocationAnnotation.getMethods().add((Object)allocMethod);
    }

    private void addAllocAnnotation(TRCClass allocClass) {
        TRCObjectAllocationAnnotation allocationAnnotation = this.createAllocAnnotation();
        allocationAnnotation.getClasses().add((Object)allocClass);
    }

    private TRCObjectAllocationAnnotation createAllocAnnotation() {
        TRCObjectAllocationAnnotation allocationAnnotation = null;
        int i = 0;
        int length = this.theClass.getAnnotations().size();
        while (i < length) {
            TRCAnnotation annotation = (TRCAnnotation)this.theClass.getAnnotations().get(i);
            if (annotation instanceof TRCObjectAllocationAnnotation) {
                allocationAnnotation = (TRCObjectAllocationAnnotation)annotation;
            }
            ++i;
        }
        if (allocationAnnotation == null) {
            allocationAnnotation = TraceFactory.eINSTANCE.createTRCObjectAllocationAnnotation();
            allocationAnnotation.setName("objAllocInfo");
            this.theClass.getAnnotations().add((Object)allocationAnnotation);
        }
        if (this.aLineNr != -1) {
            allocationAnnotation.getLineNumbers().add((Object)new Integer(this.aLineNr));
        }
        if (this.time > 0.0) {
            allocationAnnotation.getCreateTimes().add((Object)new Double(this.createDeltaTime()));
        }
        return allocationAnnotation;
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        super.initialize(context, name);
        this.isArray = 0;
        this.objId = 0L;
        this.size = 0;
        this.aMethodIdRef = 0;
        this.aClassIdRef = 0L;
        this.aLineNr = -1;
    }

    protected void processENI(int step) {
        if (step == 1) {
            if (this.theClass != null) {
                return;
            }
            this.updateTheClass(TRCFullTraceObject.class);
        } else if (step == 2 && this.virtualObject == null && this.theObject == null) {
            this.updateVirtualObject(this.objId, this.size);
        }
    }

    protected void processEF(int step) {
        super.processEF(step);
        switch (step) {
            case 1: {
                if (this.theClass != null) break;
                this.updateTheClass(TRCFullTraceObject.class);
                break;
            }
            case 2: {
                if (this.theObject == null || !(this.theObject instanceof TRCFullTraceObject)) {
                    this.theObject = (TRCFullTraceObject)LookupServiceExtensions.getInstance().locate(this.context, TRCFullTraceObjectImpl.class, this.objId);
                }
                if (this.theObject == null) {
                    this.theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
                }
                this.theObject.setId(this.objId);
                this.theObject.setSize(this.size);
                ((TRCFullTraceObject)this.theObject).setCreateTime(this.createDeltaTime());
                ((TRCFullTraceObject)this.theObject).setThread(this.theThread);
                this.theObject.setIsA(this.theClass);
                this.theObject.setProcess(this.theProcess);
                TraceUtils.removeVirtualObject(this.context, this.objId);
            }
        }
    }

    protected void processES(int step) {
        super.processES(step);
        if (step == 1) {
            if (this.theClass != null) {
                return;
            }
            this.updateTheClass(TRCFullTraceObject.class);
        } else if (step == 2 && this.virtualObject == null && this.theObject == null) {
            this.updateVirtualObject(this.objId, this.size);
        }
    }

    protected void processHF(int step) {
        super.processHF(step);
        switch (step) {
            case 1: {
                if (this.theClass != null) break;
                Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS") ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class;
                this.updateTheClass(clazz);
                break;
            }
            case 2: {
                Class clazz;
                Class clazz2 = clazz = TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS") ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class;
                if (this.theObject == null || !(this.theObject instanceof TRCHeapObject)) {
                    this.theObject = (TRCHeapObject)LookupServiceExtensions.getInstance().locate(this.context, clazz, this.objId);
                }
                if (this.theObject == null) {
                    this.theObject = TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS") ? TraceFactory.eINSTANCE.createTRCFullHeapObject() : TraceFactory.eINSTANCE.createTRCHeapObject();
                }
                this.theObject.setId(this.objId);
                this.theObject.setProcess(this.theProcess);
                this.theObject.setIsA(this.theClass);
                this.theObject.setSize(this.size);
                if (TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS")) {
                    ((TRCFullHeapObject)this.theObject).setHeapDumpFirstSeen(this.firstSeenIndex);
                }
                if (this.virtualObject != null) break;
                this.updateVirtualObject(this.objId, this.size);
                break;
            }
        }
    }

    protected void processHS(int step) {
        super.processHS(step);
        if (step == 1) {
            if (this.theClass != null) {
                return;
            }
            this.updateTheClass(TRCHeapObjectImpl.class);
        } else if (step == 2 && this.virtualObject == null && this.theObject == null) {
            this.updateVirtualObject(this.objId, this.size);
        }
    }

    private void createTRCObject() {
        this.theProcess = this.getProcess();
        if (this.objId == 0L) {
            this.objId = -this.classIdRef;
        }
        this.theThread = this.getThreadByIdRef(this.theProcess);
        if (this.objId >= 0L) {
            this.dispatchProcessMode(1);
            this.dispatchProcessMode(2);
            this.updateClassStatistics(this.size);
        }
    }

    private void updateClassStatistics(int s) {
        this.theClass.setTotalInstances(this.theClass.getTotalInstances() + 1);
        this.theClass.setTotalSize(this.theClass.getTotalSize() + s);
        TRCPackage thePackage = this.theClass.getPackage();
        thePackage.setTotalInstances(thePackage.getTotalInstances() + 1);
        thePackage.setTotalSize(thePackage.getTotalSize() + s);
        this.theProcess.setTotalInstances(this.theProcess.getTotalInstances() + 1);
        this.theProcess.setTotalSize(this.theProcess.getTotalSize() + s);
    }

    private void updateTheClass(Class classObject) {
        this.theClass = this.getClassByIdRef(this.theThread, classObject, this.isArray);
        if (this.isArray > 0 && ((TRCArrayClass)this.theClass).getElementType() == null) {
            TRCClass elementType = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.classIdRef);
            ((TRCArrayClass)this.theClass).setElementType(elementType);
        }
    }
}

