/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.configuration.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

public class ConfigurationUtil {
    public static final String CLASSPATH = "CLASSPATH";
    public static final String ROOTDIR = "ROOTDIR";
    public static final String USED_ROOTDIR = "USED_ROOTDIR";
    public static final String ATTRS_PROP_GROUP_ID_ARTIFACT = "org.eclipse.hyades.test.configuration.artifact.attributes";
    public static final String ATTRS_PROP_GROUP_ID_LOCATION = "org.eclipse.hyades.test.configuration.location.attributes";
    public static final String USR_NAME = "USR_NAME";
    public static final String LOCALHOST = "localhost";
    public static final String DEFAULT_DEPLOYMENT_NAME = "local_deployment";
    public static final String DEFAULT_DEPLOYMENT_ID = "default";

    public static TPFDeployment createDeployment(String name, String description) {
        TPFDeployment deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
        if (name != null) {
            deployment.setName(name);
        }
        if (description != null && description.trim().length() > 0) {
            deployment.setDescription(description);
        }
        return deployment;
    }

    public static TPFDeployment createDefaultDeployment() {
        TPFDeployment defaultDeployment = ConfigurationUtil.createDeployment(DEFAULT_DEPLOYMENT_NAME, "");
        defaultDeployment.setId(DEFAULT_DEPLOYMENT_ID);
        defaultDeployment.getRefLocations().add((Object)ConfigurationUtil.createLocation());
        return defaultDeployment;
    }

    public static boolean isDefaultDeployment(TPFDeployment deployment) {
        return DEFAULT_DEPLOYMENT_ID.equals(deployment.getId());
    }

    public static TPFDeployment createDeploymentWithPair(String name, String description, CFGClass testAsset, String hostname) {
        TPFDeployment deployment = ConfigurationUtil.createDeployment(name, description);
        CFGArtifact artifact = ConfigurationUtil.createArtifact(null, null);
        artifact.getDeployableInstances().add((Object)testAsset);
        CFGLocation location = ConfigurationUtil.createLocation(null, null, hostname);
        CFGArtifactLocationPair pair = ConfigurationUtil.createArtifactLocationPair(artifact, location);
        deployment.getArtifactLocations().add((Object)pair);
        return deployment;
    }

    public static CFGArtifact createArtifact(String name, String description) {
        CFGArtifact artifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
        if (name != null) {
            artifact.setName(name);
        }
        if (description != null && description.trim().length() > 0) {
            artifact.setDescription(description);
        }
        return artifact;
    }

    public static CFGLocation createLocation(String name, String description, String hostname) {
        CFGLocation location = ConfigurationUtil.createLocation();
        if (name != null) {
            location.setName(name);
        }
        if (description != null && description.trim().length() > 0) {
            location.setDescription(description);
        }
        if (hostname != null && location instanceof CFGMachineConstraint) {
            ((CFGMachineConstraint)location).setHostname(hostname);
        }
        return location;
    }

    public static CFGLocation createLocation() {
        CFGMachineConstraint machine = Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint();
        String hostname = LOCALHOST;
        machine.setHostname(hostname);
        return machine;
    }

    public static CFGArtifactLocationPair searchPairWithTestAsset(CFGClass testAsset, TPFDeployment deployment) {
        if (testAsset == null || deployment == null) {
            return null;
        }
        ConfigurationUtil.cleanUpPairs(deployment);
        CFGArtifactLocationPair pair2 = null;
        CFGArtifact artifact = null;
        for (CFGArtifactLocationPair pair2 : deployment.getArtifactLocations()) {
            artifact = pair2.getArtifact();
            if (!ConfigurationUtil.containsById(artifact.getDeployableInstances(), testAsset)) continue;
            return pair2;
        }
        return null;
    }

    private static void cleanUpPairs(TPFDeployment deployment) {
        CFGArtifactLocationPair pair2 = null;
        ArrayList<CFGArtifactLocationPair> pairToRemove = new ArrayList<CFGArtifactLocationPair>();
        for (CFGArtifactLocationPair pair2 : deployment.getArtifactLocations()) {
            if (pair2.getArtifact() != null && pair2.getLocation() != null) continue;
            pairToRemove.add(pair2);
        }
        Iterator i = pairToRemove.iterator();
        while (i.hasNext()) {
            deployment.getArtifactLocations().remove(i.next());
        }
    }

    public static CFGLocation searchLocationWithTestAsset(CFGClass testAsset, TPFDeployment deployment) {
        CFGArtifactLocationPair pair = ConfigurationUtil.searchPairWithTestAsset(testAsset, deployment);
        if (pair != null) {
            return pair.getLocation();
        }
        return null;
    }

    public static CFGArtifact searchArtifactWithTestAsset(CFGClass testAsset, TPFDeployment deployment) {
        if (testAsset == null || deployment == null) {
            return null;
        }
        CFGArtifact artifact2 = null;
        for (CFGArtifact artifact2 : deployment.getArtifacts()) {
            if (!ConfigurationUtil.containsById(artifact2.getDeployableInstances(), testAsset)) continue;
            return artifact2;
        }
        return null;
    }

    public static CFGArtifactLocationPair createArtifactLocationPair(CFGArtifact artifact, CFGLocation location) {
        CFGArtifactLocationPair pair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
        pair.setArtifact(artifact);
        pair.setLocation(location);
        return pair;
    }

    public static BVRProperty[] searchPropertiesByName(List properties, String name, boolean caseSensitive) {
        if (properties != null && !properties.isEmpty() && name != null) {
            ArrayList<BVRProperty> ret = new ArrayList<BVRProperty>();
            for (BVRProperty property : properties) {
                if (caseSensitive) {
                    if (!name.equals(property.getName())) continue;
                    ret.add(property);
                    continue;
                }
                if (!name.equalsIgnoreCase(property.getName())) continue;
                ret.add(property);
            }
            return ret.toArray(new BVRProperty[ret.size()]);
        }
        return new BVRProperty[0];
    }

    public static CFGPropertyGroup searchPropertyGroupById(List propertyGroups, String propGroupId) {
        if (propertyGroups == null || propertyGroups.isEmpty() || propGroupId == null) {
            return null;
        }
        CFGPropertyGroup group = null;
        for (Object next : propertyGroups) {
            if (!(next instanceof CFGPropertyGroup) || ((CFGPropertyGroup)next).getPropertyGroupID() == null || !((CFGPropertyGroup)next).getPropertyGroupID().equals(propGroupId)) continue;
            group = (CFGPropertyGroup)next;
            break;
        }
        return group;
    }

    public static boolean containsById(List namedElementList, CMNNamedElement element) {
        if (namedElementList.isEmpty()) {
            return false;
        }
        for (Object obj : namedElementList) {
            if (!(obj instanceof CMNNamedElement) || !((CMNNamedElement)obj).getId().equals(element.getId())) continue;
            return true;
        }
        return false;
    }

    public static String getHostNameForTestAsset(CFGClass rootResource, TPFDeployment deployment) {
        CFGArtifactLocationPair pair;
        String machineName = null;
        if (!deployment.getArtifactLocations().isEmpty() && (pair = ConfigurationUtil.searchPairWithTestAsset(rootResource, deployment)) != null) {
            CFGLocation location = pair.getLocation();
            if (location instanceof CFGMachineConstraint) {
                machineName = ((CFGMachineConstraint)location).getHostname();
            } else if (location != null) {
                machineName = location.getName();
            }
        }
        return machineName;
    }

    public static String getHostName(CFGLocation location) {
        if (location == null) {
            return null;
        }
        if (location instanceof CFGMachineConstraint) {
            return ((CFGMachineConstraint)location).getHostname();
        }
        return location.getName();
    }

    public static CFGLocation getDefaultLocation(TPFDeployment deployment) {
        CFGLocation location = null;
        if (ConfigurationUtil.isDefaultLocation(deployment)) {
            if (deployment.getLocations().size() == 1) {
                location = (CFGLocation)deployment.getLocations().get(0);
            } else if (deployment.getRefLocations().size() == 1) {
                location = (CFGLocation)deployment.getRefLocations().get(0);
            }
        }
        return location;
    }

    public static boolean isDefaultLocation(TPFDeployment deployment) {
        return deployment.getArtifactLocations().isEmpty() && (deployment.getLocations().size() == 1 || deployment.getRefLocations().size() == 1);
    }
}

