/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DPLRole implements Enumerator
{
    UNSPECIFIED_DATA_LITERAL(0, "UnspecifiedData", "UnspecifiedData"),
    INPUT_DATA_LITERAL(1, "InputData", "InputData"),
    OUTPUT_DATA_LITERAL(2, "OutputData", "OutputData"),
    INPUT_OUTPUT_DATA_LITERAL(3, "InputOutputData", "InputOutputData");

    public static final int UNSPECIFIED_DATA = 0;
    public static final int INPUT_DATA = 1;
    public static final int OUTPUT_DATA = 2;
    public static final int INPUT_OUTPUT_DATA = 3;
    private static final DPLRole[] VALUES_ARRAY;
    public static final List<DPLRole> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DPLRole[]{UNSPECIFIED_DATA_LITERAL, INPUT_DATA_LITERAL, OUTPUT_DATA_LITERAL, INPUT_OUTPUT_DATA_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DPLRole get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DPLRole result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DPLRole getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DPLRole result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DPLRole get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED_DATA_LITERAL;
            }
            case 1: {
                return INPUT_DATA_LITERAL;
            }
            case 2: {
                return OUTPUT_DATA_LITERAL;
            }
            case 3: {
                return INPUT_OUTPUT_DATA_LITERAL;
            }
        }
        return null;
    }

    private DPLRole(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

