/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.util.DPLPasswordCollection;
import org.eclipse.hyades.models.common.util.DatapoolUtil;
import org.eclipse.hyades.models.common.util.EncryptionManager;

public class DPLCellImpl
extends EObjectImpl
implements DPLCell {
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected DPLVariable variable;
    private static final Pattern XML_FRAGMENT_PATTERN = Pattern.compile("<\\s*(\\w+)\\s*>(.*)</\\s*(\\w+)\\s*>");
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";

    protected DPLCellImpl() {
    }

    protected EClass eStaticClass() {
        return Common_DatapoolPackage.Literals.DPL_CELL;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldValue, (Object)this.value));
        }
    }

    public DPLVariable getVariable() {
        if (this.variable != null && this.variable.eIsProxy()) {
            InternalEObject oldVariable = (InternalEObject)this.variable;
            this.variable = (DPLVariable)this.eResolveProxy(oldVariable);
            if (this.variable != oldVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldVariable, (Object)this.variable));
            }
        }
        return this.variable;
    }

    public DPLVariable basicGetVariable() {
        return this.variable;
    }

    public void setVariable(DPLVariable newVariable) {
        DPLVariable oldVariable = this.variable;
        this.variable = newVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldVariable, (Object)this.variable));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                if (resolve) {
                    return this.getVariable();
                }
                return this.basicGetVariable();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setValue((String)newValue);
                return;
            }
            case 1: {
                this.setVariable((DPLVariable)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setVariable(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 1: {
                return this.variable != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public void setVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable) {
        this.setVariable((DPLVariable)variable);
    }

    public String getPersistedRepresentation() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        return this.wrapAsLiteral(new String());
    }

    public IDatapoolVariable getCellVariable() {
        return this.getVariable();
    }

    public IDatapoolRecord getCellRecord() {
        return (IDatapoolRecord)this.eContainer();
    }

    public Object getCellValue() {
        String cellValue = this.getValue();
        if (cellValue == null) {
            return null;
        }
        String trimmedCellValue = cellValue.trim();
        if (trimmedCellValue.startsWith("<")) {
            if (trimmedCellValue.startsWith(START_LITERAL) && trimmedCellValue.endsWith(END_LITERAL)) {
                return this.decryptValue(trimmedCellValue.substring(START_LITERAL.length(), trimmedCellValue.length() - END_LITERAL.length()));
            }
            try {
                IDatapoolEvaluatorExt evaluator;
                Matcher matcher = XML_FRAGMENT_PATTERN.matcher(trimmedCellValue);
                if (matcher.matches() && (evaluator = DatapoolUtil.findDatapoolEvaluator(matcher.group(1))) != null) {
                    return this.decryptValue(evaluator.evaluate(matcher.group(2)));
                }
            }
            catch (Throwable throwable) {}
        }
        return this.decryptValue(cellValue);
    }

    public String getStringValue() {
        Object cellValue = this.getCellValue();
        if (cellValue != null) {
            return cellValue.toString();
        }
        return new String();
    }

    public long getLongValue() {
        return Long.parseLong((String)this.getCellValue());
    }

    public int getIntValue() {
        return Integer.parseInt((String)this.getCellValue());
    }

    public short getShortValue() {
        return Short.parseShort((String)this.getCellValue());
    }

    public byte getByteValue() {
        return Byte.parseByte((String)this.getCellValue());
    }

    public double getDoubleValue() {
        return Double.parseDouble((String)this.getCellValue());
    }

    public float getFloatValue() {
        return Float.parseFloat((String)this.getCellValue());
    }

    public boolean getBooleanValue() {
        return Boolean.valueOf((String)this.getCellValue());
    }

    public char getCharValue() {
        return ((String)this.getCellValue()).charAt(0);
    }

    public void setPersistedRepresentation(String value) {
        this.setValue(value);
    }

    public void setCellValue(Object cellObject) {
        if (cellObject == null) {
            this.setValue("");
        } else {
            String cellValue = cellObject.toString();
            String trimmedCellValue = cellValue.trim();
            if (trimmedCellValue.startsWith("<")) {
                try {
                    Matcher matcher = XML_FRAGMENT_PATTERN.matcher(trimmedCellValue);
                    if (matcher.matches() && DatapoolUtil.findDatapoolEvaluator(matcher.group(1)) != null) {
                        this.setValue(cellValue);
                        return;
                    }
                }
                catch (Throwable throwable) {}
            }
            if (trimmedCellValue.startsWith(START_LITERAL) && trimmedCellValue.endsWith(END_LITERAL)) {
                this.setValue(cellValue);
            } else {
                this.setValue(this.wrapAsLiteral(cellValue));
            }
        }
    }

    public Object getClonedCellValue() {
        return this.getCellValue();
    }

    private String wrapAsLiteral(String text) {
        if (text != null) {
            return START_LITERAL + text + END_LITERAL;
        }
        return "<Literal></Literal>";
    }

    private Object decryptValue(Object value) {
        if (this.getVariable().isEncrypted() && value instanceof String) {
            String password;
            String datapoolName = this.getCellRecord().getEquivalenceClass().getDatapool().getName();
            HashMap datapoolPasswordMap = DPLPasswordCollection.getInstance().getDatapoolPassword();
            if (datapoolName != null && datapoolPasswordMap != null && (password = (String)datapoolPasswordMap.get(datapoolName)) != null) {
                return EncryptionManager.decrypt((String)value, password);
            }
        }
        return value;
    }
}

