/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.util;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl;
import org.eclipse.hyades.models.common.util.EncryptionManager;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

public class DatapoolEncryptManager {
    public static void encryptedCellInVarible(IDatapoolVariable varible, String key, IDatapool datapool) {
        int index = datapool.getDefaultEquivalenceClassIndex();
        if (index == -1) {
            return;
        }
        IDatapoolEquivalenceClass equivalenceClass = datapool.getEquivalenceClass(index);
        int i = 0;
        while (i < equivalenceClass.getRecordCount()) {
            IDatapoolRecord record = (IDatapoolRecord)equivalenceClass.getRecord(i);
            int k = 0;
            while (k < record.getCellCount()) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                if (cell.getCellVariable().getId().equals(varible.getId())) {
                    cell.setCellValue(EncryptionManager.encrypt(cell.getStringValue(), key));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void decryptedCellInVarible(IDatapoolVariable variable, String key, IDatapool datapool) {
        int index = datapool.getDefaultEquivalenceClassIndex();
        if (index == -1) {
            return;
        }
        IDatapoolEquivalenceClass equivalenceClass = datapool.getEquivalenceClass(index);
        int i = 0;
        while (i < equivalenceClass.getRecordCount()) {
            IDatapoolRecord record = (IDatapoolRecord)equivalenceClass.getRecord(i);
            int k = 0;
            while (k < record.getCellCount()) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                if (cell.getCellVariable().getId().equals(variable.getId())) {
                    cell.setCellValue(EncryptionManager.decrypt(cell.getStringValue(), key));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void removeKey(IDatapool datapool) {
        DatapoolEncryptManager.changeKey(null, datapool);
    }

    public static void changeKey(String newKey, IDatapool datapool) {
        if (datapool instanceof DPLDatapool) {
            if (newKey != null && newKey.trim().length() > 0) {
                try {
                    ((DPLDatapool)datapool).setChallenge(EncryptionManager.EncoderByMd5(newKey));
                }
                catch (Exception e) {
                    ModelsPlugin.getPlugin().log(e);
                }
            } else {
                ((DPLDatapool)datapool).setChallenge(null);
            }
        }
    }

    public static void changeKeyOfEncryptedCell(IDatapool datapool, String oldKey, String newKey) {
        int variableCount = datapool.getVariableCount();
        IDatapoolVariable variable = null;
        int i = 0;
        while (i < variableCount) {
            variable = datapool.getVariable(i);
            if (DatapoolEncryptManager.isVariableEncrypted(variable)) {
                DatapoolEncryptManager.decryptedCellInVarible(variable, oldKey, datapool);
                DatapoolEncryptManager.encryptedCellInVarible(variable, newKey, datapool);
            }
            ++i;
        }
    }

    public static void decryptDatapool(IDatapool datapool, String key) {
        int variableCount = datapool.getVariableCount();
        IDatapoolVariable variable = null;
        int i = 0;
        while (i < variableCount) {
            variable = datapool.getVariable(i);
            if (DatapoolEncryptManager.isVariableEncrypted(variable)) {
                DatapoolEncryptManager.decryptedCellInVarible(variable, key, datapool);
            }
            ++i;
        }
    }

    public static void encryptDatapool(IDatapool datapool, String key) {
        int variableCount = datapool.getVariableCount();
        IDatapoolVariable variable = null;
        int i = 0;
        while (i < variableCount) {
            variable = datapool.getVariable(i);
            if (DatapoolEncryptManager.isVariableEncrypted(variable)) {
                DatapoolEncryptManager.encryptedCellInVarible(variable, key, datapool);
            }
            ++i;
        }
    }

    public static boolean isDatapoolEncrypted(IDatapool datapool) {
        if (!(datapool instanceof DPLDatapool)) {
            return false;
        }
        return ((DPLDatapool)datapool).getChallenge() != null && !((DPLDatapool)datapool).getChallenge().equals("");
    }

    public static boolean containsEncryptedVariable(IDatapool datapool) {
        boolean containsEncryptedVariable = false;
        int variableCount = datapool.getVariableCount();
        int i = 0;
        while (i < variableCount) {
            if (DatapoolEncryptManager.isVariableEncrypted((DPLVariableImpl)datapool.getVariable(i))) {
                containsEncryptedVariable = true;
                break;
            }
            ++i;
        }
        return containsEncryptedVariable;
    }

    public static boolean isKeyCorrect(IDatapool datapool, String key) {
        if (!(datapool instanceof DPLDatapool)) {
            return false;
        }
        if (key == null) {
            return false;
        }
        boolean flag = false;
        try {
            flag = EncryptionManager.EncoderByMd5(key).equals(((DPLDatapool)datapool).getChallenge());
        }
        catch (Exception e) {
            ModelsPlugin.getPlugin().log("invalid key exception occurs");
            ModelsPlugin.getPlugin().log(e);
        }
        return flag;
    }

    public static boolean isVariableEncrypted(IDatapoolVariable varible) {
        return varible instanceof DPLVariable ? ((DPLVariable)varible).isEncrypted() : false;
    }

    public static String encrypt(String content, String pass) {
        return EncryptionManager.encrypt(content, pass);
    }

    public static String decrypt(String content, String pass) {
        return EncryptionManager.decrypt(content, pass);
    }
}

