/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.IAnnotatableResource;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesCommon_Behavior_FragmentsAdapterFactory;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesCommon_TestprofileAdapterFactory;
import org.eclipse.hyades.models.common.facades.behavioral.impl.TptpCommon_BVRExecutionOccurrenceAdapterFactory;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.util.FileUtil;
import org.eclipse.hyades.models.hierarchy.util.HierarchyURIConverterImpl;

public class FacadeResourceImpl
extends XMIResourceImpl
implements IAnnotatableResource {
    private File annotationDir = null;
    private static List annotationDirectories = new ArrayList();
    private static boolean shutdownHookRegistered = false;
    private static Thread shutdownThread = new Thread(){

        public void run() {
            for (File dir : annotationDirectories) {
                if (dir == null || !dir.exists() || (dir = dir.getParentFile()) == null || !dir.exists()) continue;
                FileUtil.deltree(dir);
            }
        }
    };
    public static final String ANNOTATION_QUERY = "annotationID=/";

    public FacadeResourceImpl() {
        this.registerCleanupHook();
    }

    public FacadeResourceImpl(URI arg0) {
        super(arg0);
        this.registerCleanupHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCleanupHook() {
        Class<FacadeResourceImpl> clazz = FacadeResourceImpl.class;
        synchronized (FacadeResourceImpl.class) {
            if (!shutdownHookRegistered) {
                Runtime.getRuntime().addShutdownHook(shutdownThread);
                shutdownHookRegistered = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void attached(EObject arg0) {
        AdapterFactoryImpl adaptorFactory;
        super.attached(arg0);
        String id = EcoreUtil.getID((EObject)arg0);
        if (id != null) {
            this.getIDToEObjectMap().put(id, arg0);
        }
        if (arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite())) {
            adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        }
        if (arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction())) {
            adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction());
        }
        if (arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand())) {
            adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand());
        }
        if (arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestComponent())) {
            adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_TestprofilePackage.eINSTANCE.getTPFTestComponent());
        }
        if (arg0.eClass().equals(Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence())) {
            adaptorFactory = new TptpCommon_BVRExecutionOccurrenceAdapterFactory();
            adaptorFactory.adapt((Notifier)arg0, (Object)Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence());
        }
    }

    public void detached(EObject arg0) {
        super.detached(arg0);
        arg0.eAdapters().clear();
        String id = EcoreUtil.getID((EObject)arg0);
        if (id != null) {
            this.getIDToEObjectMap().remove(id);
        }
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        if (options == null) {
            options = new HashMap<String, Boolean>();
        }
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        if (inputStream instanceof ZipInputStream) {
            ZipInputStream zipIn = (ZipInputStream)inputStream;
            File tempResourceContents = File.createTempFile("tempResource", "");
            tempResourceContents.deleteOnExit();
            try {
                int count;
                FileOutputStream file = new FileOutputStream(tempResourceContents);
                BufferedOutputStream bufFile = new BufferedOutputStream(file);
                int bufSize = 65536;
                byte[] readBuffer = new byte[bufSize];
                while ((count = zipIn.read(readBuffer, 0, bufSize)) != -1) {
                    bufFile.write(readBuffer, 0, count);
                }
                bufFile.close();
                ZipEntry entry = zipIn.getNextEntry();
                if (entry != null) {
                    URI baseAnnotationDirURI = URI.createFileURI((String)this.getAnnotationDir().getAbsolutePath());
                    while (entry != null) {
                        String entryName = entry.getName();
                        URI relativeURI = URI.createURI((String)entryName);
                        URI fileURI = relativeURI.resolve(baseAnnotationDirURI);
                        File dest = new File(fileURI.toFileString());
                        if (!dest.getParentFile().exists()) {
                            dest.getParentFile().mkdirs();
                        }
                        file = new FileOutputStream(fileURI.toFileString());
                        bufFile = new BufferedOutputStream(file);
                        while ((count = zipIn.read(readBuffer, 0, bufSize)) != -1) {
                            bufFile.write(readBuffer, 0, count);
                        }
                        bufFile.close();
                        entry = zipIn.getNextEntry();
                    }
                }
                FileInputStream fileIn = new FileInputStream(tempResourceContents);
                BufferedInputStream bufIn = new BufferedInputStream(fileIn);
                super.doLoad((InputStream)bufIn, options);
                bufIn.close();
            }
            finally {
                tempResourceContents.delete();
            }
        } else {
            super.doLoad(inputStream, options);
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        super.doSave(outputStream, options);
        if (this.hasAnnotations() && outputStream instanceof ZipOutputStream) {
            ZipOutputStream zipOut = (ZipOutputStream)outputStream;
            File annotationDir = this.getAnnotationDir();
            URI baseAnnotationDirURI = URI.createFileURI((String)annotationDir.getAbsolutePath());
            File[] annotations = FileUtil.listAllFiles(annotationDir);
            if (annotations == null) {
                return;
            }
            int i = 0;
            while (i < annotations.length) {
                int count;
                URI currentFile = URI.createFileURI((String)annotations[i].getAbsolutePath());
                URI relativeURI = currentFile.deresolve(baseAnnotationDirURI);
                FileInputStream in = new FileInputStream(annotations[i]);
                ZipEntry entry = new ZipEntry(relativeURI.toString());
                entry.setMethod(0);
                entry.setSize(annotations[i].length());
                CRC32 crc = new CRC32();
                BufferedInputStream contentStream = new BufferedInputStream(in);
                int bufSize = 524288;
                byte[] readBuffer = new byte[bufSize];
                while ((count = contentStream.read(readBuffer, 0, bufSize)) != -1) {
                    crc.update(readBuffer, 0, count);
                }
                contentStream.close();
                entry.setCrc(crc.getValue());
                zipOut.putNextEntry(entry);
                in = new FileInputStream(annotations[i]);
                contentStream = new BufferedInputStream(in);
                while ((count = contentStream.read(readBuffer, 0, bufSize)) != -1) {
                    zipOut.write(readBuffer, 0, count);
                }
                zipOut.closeEntry();
                contentStream.close();
                ++i;
            }
        }
    }

    public boolean hasAnnotations() {
        return this.annotationDir != null;
    }

    public synchronized File getAnnotationDir() throws IOException {
        if (this.annotationDir != null) {
            return this.annotationDir;
        }
        File systemTempDir = FileUtil.getTempDir();
        File temp = File.createTempFile("Hyades.TestModel.AnnotationDir", "", systemTempDir);
        if (temp.delete() && temp.mkdir()) {
            this.annotationDir = new File(temp, "annotations");
            if (!this.annotationDir.mkdir()) {
                throw new IOException("Unable to create new annotation Dir " + this.annotationDir.getAbsolutePath());
            }
        } else {
            throw new IOException("Unable to create new annotation Dir " + temp.getAbsolutePath());
        }
        annotationDirectories.add(this.annotationDir);
        return this.annotationDir;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void cleanup() {
        this.cleanupAnnotationDir();
    }

    private void cleanupAnnotationDir() {
        if (this.hasAnnotations()) {
            boolean deleted = FileUtil.deltree(this.annotationDir.getParentFile());
            if (deleted) {
                annotationDirectories.remove(this.annotationDir);
            }
            this.annotationDir = null;
        }
    }

    protected void doUnload() {
        super.doUnload();
        this.cleanupAnnotationDir();
        this.annotationDir = null;
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return null;
    }

    protected URIConverter getURIConverter() {
        return new HierarchyURIConverterImpl();
    }

    public URI getFileAnnotation(CMNAnnotation annotationElement) throws IOException {
        String uriString = annotationElement.getURI();
        File annotationDir = this.getAnnotationDir();
        URI baseAnnotationDirURI = URI.createFileURI((String)annotationDir.getAbsolutePath());
        URI annotation = URI.createURI((String)uriString);
        annotation = this.queryURItoRelativeURI(annotation);
        URI resolvedURI = annotation.resolve(baseAnnotationDirURI);
        return resolvedURI;
    }

    public boolean isFileAnnotation(CMNAnnotation annotationElement) {
        String uriString = annotationElement.getURI();
        if (uriString == null || uriString.length() == 0) {
            return false;
        }
        URI uri = URI.createURI((String)uriString);
        return (uri = this.queryURItoRelativeURI(uri)).isFile();
    }

    public void putFileAnnotation(URI file, CMNAnnotation annotationElement) throws IOException {
        File srcFile;
        String containerID = this.getContainerID(annotationElement);
        File annotationDir = this.getAnnotationDir();
        File objectAnnotationDir = new File(annotationDir, containerID != null ? containerID : String.valueOf(System.currentTimeMillis()));
        if (!objectAnnotationDir.exists()) {
            if (!objectAnnotationDir.mkdir()) {
                throw new IOException("Collision making directory " + objectAnnotationDir.getAbsolutePath());
            }
        } else if (!objectAnnotationDir.isDirectory()) {
            throw new IOException("Object annotation dir name exists as file " + objectAnnotationDir.getAbsolutePath());
        }
        if (!(srcFile = new File(file.toFileString())).exists()) {
            throw new IOException("Specified file does not exist " + file.toFileString());
        }
        File destFile = new File(objectAnnotationDir, srcFile.getName());
        if (destFile.exists()) {
            throw new IOException("FileAnnotation of same name (" + srcFile.getName() + ") already exists on object " + annotationElement.eContainer().toString());
        }
        FileUtil.copyFileSafe(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
        URI baseAnnotationDirURI = URI.createFileURI((String)annotationDir.getAbsolutePath());
        URI annotation = URI.createFileURI((String)destFile.getAbsolutePath());
        URI relativeURI = annotation.deresolve(baseAnnotationDirURI);
        annotationElement.setURI(this.relativeURItoQueryURI(relativeURI).toString());
    }

    public void removeFileAnnotation(CMNAnnotation annotationImpl) throws IOException {
        URI resolvedURI = annotationImpl.getFileAnnotation();
        File file = new File(resolvedURI.toFileString());
        try {
            if (file.exists()) {
                File[] siblings;
                file.delete();
                File parentDir = file.getParentFile();
                if (parentDir.exists() && (siblings = parentDir.listFiles()).length == 0) {
                    parentDir.delete();
                }
            }
        }
        catch (Throwable throwable) {}
    }

    private URI queryURItoRelativeURI(URI uri) {
        if (uri.hasQuery()) {
            String query = uri.query();
            String uriString = query.replaceFirst(ANNOTATION_QUERY, "");
            uri = URI.createURI((String)uriString);
        }
        return uri;
    }

    private URI relativeURItoQueryURI(URI uri) {
        if (!uri.hasQuery()) {
            String queryString = ANNOTATION_QUERY + uri.toString();
            uri = URI.createHierarchicalURI(null, null, null, (String)queryString, null);
        }
        return uri;
    }

    private String getContainerID(CMNAnnotation annotationElement) throws UnsupportedOperationException {
        String containerID;
        EObject container = annotationElement.eContainer();
        if (container == null) {
            throw new UnsupportedOperationException("FileAnnotation must be contained in a model element");
        }
        if (container instanceof CMNNamedElement) {
            CMNNamedElement con = (CMNNamedElement)container;
            containerID = con.getId();
        } else if (container instanceof TPFExecutionEvent) {
            TPFExecutionEvent con = (TPFExecutionEvent)container;
            containerID = con.getId();
        } else {
            throw new UnsupportedOperationException("Annotations not supported for container of type " + container);
        }
        return containerID;
    }
}

