/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

public class HyadesTPFTestSuiteAdapter
extends AdapterImpl {
    public boolean isAdapterForType(Object arg0) {
        if (arg0 instanceof EObject) {
            return ((EObject)arg0).eClass() == Common_TestprofilePackage.eINSTANCE.getTPFTestSuite();
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 3 || eventType == 5 || eventType == 4 || eventType == 6) {
            TPFTestSuiteImpl suite = (TPFTestSuiteImpl)notification.getNotifier();
            if (!"HyadesFacadeResource".equals(suite.getPersistenceId())) {
                return;
            }
            Iterator iter = null;
            block0 : switch (notification.getFeatureID(TPFTestSuite.class)) {
                case 11: {
                    IImplementor implementor = suite.getImplementor();
                    IBlock block = null;
                    if (implementor != null) {
                        block = implementor.getBlock();
                    }
                    CFGClassImpl sut2 = null;
                    TPFSUTImpl systemUnderTest = null;
                    List systemsUnderTest = null;
                    int numOfInstances = 0;
                    switch (eventType) {
                        case 3: {
                            systemUnderTest = (TPFSUTImpl)notification.getNewValue();
                            sut2 = systemUnderTest;
                            if (sut2.getInstances().size() <= 0 || ((CFGInstanceImpl)sut2.getInstances().get(0)).getLifeline() != null || block == null) break block0;
                            BVRLifelineImpl lifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
                            ((CFGInstanceImpl)sut2.getInstances().get(0)).setLifeline(lifeline);
                            ((BVRInteractionImpl)block).getLifelines().add((Object)lifeline);
                            break;
                        }
                        case 5: {
                            systemsUnderTest = (List)notification.getNewValue();
                            for (CFGClassImpl sut2 : systemsUnderTest) {
                                if (sut2.getInstances().size() <= 0 || ((CFGInstanceImpl)sut2.getInstances().get(0)).getLifeline() != null || block == null) continue;
                                BVRLifelineImpl lifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
                                ((CFGInstanceImpl)sut2.getInstances().get(0)).setLifeline(lifeline);
                                ((BVRInteractionImpl)block).getLifelines().add((Object)lifeline);
                            }
                            break block0;
                        }
                        case 4: {
                            systemUnderTest = (TPFSUTImpl)notification.getOldValue();
                            sut2 = systemUnderTest;
                            numOfInstances = sut2.getInstances().size();
                            int i = 0;
                            while (i < numOfInstances) {
                                BVRLifelineImpl lifeline = (BVRLifelineImpl)((CFGInstanceImpl)sut2.getInstances().get(i)).getLifeline();
                                lifeline.getInteraction().getLifelines().remove((Object)lifeline);
                                sut2.getInstances().remove(i);
                                ++i;
                            }
                            break block0;
                        }
                        case 6: {
                            systemsUnderTest = (List)notification.getOldValue();
                            for (CFGClassImpl sut2 : systemsUnderTest) {
                                numOfInstances = sut2.getInstances().size();
                                int i = 0;
                                while (i < numOfInstances) {
                                    BVRLifelineImpl lifeline = (BVRLifelineImpl)((CFGInstanceImpl)sut2.getInstances().get(i)).getLifeline();
                                    lifeline.getInteraction().getLifelines().remove((Object)lifeline);
                                    sut2.getInstances().remove(i);
                                    ++i;
                                }
                            }
                        }
                    }
                    break;
                }
                case 13: {
                    break;
                }
                case 10: {
                    switch (eventType) {
                        case 4: {
                            TPFTestCase testcase = (TPFTestCase)notification.getOldValue();
                            TPFBehavior behavior = testcase.getBehavior();
                            HyadesTPFTestSuiteAdapter.removeAllInvocations(suite, behavior);
                            HyadesTPFTestSuiteAdapter.removeTPFBehaviorInstances(behavior);
                            break block0;
                        }
                        case 6: {
                            List testcases = (List)notification.getOldValue();
                            for (TPFTestCase testcase : testcases) {
                                TPFBehavior behavior = testcase.getBehavior();
                                HyadesTPFTestSuiteAdapter.removeTPFBehaviorInstances(behavior);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void removeAllInvocations(TPFTestSuite suite, TPFBehavior behavior) {
        TPFBehavior currentBehavior = suite.getBehavior();
        HyadesTPFTestSuiteAdapter.removeInvocationsFromBehavior(currentBehavior, behavior);
        for (TPFTestCase testcase : suite.getTestCases()) {
            HyadesTPFTestSuiteAdapter.removeInvocationsFromBehavior(testcase.getBehavior(), behavior);
        }
        for (TPFTestComponent testComponent : suite.getTestComponents()) {
            for (TPFBehavior testComponentBehavior : testComponent.getBehaviors()) {
                HyadesTPFTestSuiteAdapter.removeInvocationsFromBehavior(testComponentBehavior, behavior);
            }
        }
    }

    public static void removeInvocationsFromBehavior(TPFBehavior currentBehavior, TPFBehavior behavior) {
        BVRInteraction interaction;
        if (currentBehavior != null && behavior != null && (interaction = currentBehavior.getInteraction()) != null) {
            Iterator iter = interaction.getInteractionFragments().iterator();
            ArrayList fragments = new ArrayList();
            while (iter.hasNext()) {
                BVRInteractionFragment fragment = (BVRInteractionFragment)iter.next();
                HyadesTPFTestSuiteAdapter.getInvocationsFromFragment(fragment, behavior, fragments);
            }
            for (EObject fragment : fragments) {
                EcoreUtil.remove((EObject)fragment);
            }
        }
    }

    private static void getInvocationsFromFragment(BVRInteractionFragment fragment, TPFBehavior behavior, List fragments) {
        if (fragment != null && behavior != null) {
            TPFBehavior otherBehavior;
            if (fragment instanceof BVRCombinedFragment) {
                for (BVRInteractionFragment childFragment : ((BVRCombinedFragment)fragment).getInteractionOperands()) {
                    HyadesTPFTestSuiteAdapter.getInvocationsFromFragment(childFragment, behavior, fragments);
                }
            } else if (fragment instanceof BVRInteractionOperand) {
                for (BVRInteractionFragment childFragment : ((BVRInteractionOperand)fragment).getInteractionFragments()) {
                    HyadesTPFTestSuiteAdapter.getInvocationsFromFragment(childFragment, behavior, fragments);
                }
            } else if (fragment instanceof BVRExecutionOccurrence && ((otherBehavior = ((BVRExecutionOccurrence)fragment).getOtherBehavior()) == null || behavior.equals(otherBehavior))) {
                fragments.add(fragment);
            }
        }
    }

    public static void removeTPFBehaviorInstances(TPFBehavior behavior) {
        BVRInteraction interaction;
        if (behavior != null && (interaction = behavior.getInteraction()) != null) {
            EList<BVRLifeline> lifelines = interaction.getLifelines();
            for (BVRLifeline lifeline : lifelines) {
                for (CFGInstance instance : lifeline.getInstances()) {
                    CFGClass classType;
                    CFGClass classOwner = instance.getClassOwner();
                    if (classOwner != null) {
                        classOwner.getInstances().remove((Object)instance);
                    }
                    if ((classType = instance.getClassType()) == null) continue;
                    classType.getInstantiations().remove((Object)instance);
                }
            }
        }
    }

    BVRLifeline getSUTLifelineFromBlock(CFGClassImpl sut, BVRInteractionImpl block) {
        EList<BVRLifeline> lifelines = block.getLifelines();
        Iterator it = lifelines.iterator();
        BVRLifelineImpl retLifeline = null;
        BVRLifelineImpl tempLifeline = null;
        while (it.hasNext()) {
            tempLifeline = (BVRLifelineImpl)it.next();
            CFGInstanceImpl instance = (CFGInstanceImpl)tempLifeline.getInstances().get(0);
            if (!((CFGClassImpl)instance.getClassOwner()).equals(sut)) continue;
            retLifeline = tempLifeline;
            break;
        }
        return retLifeline;
    }
}

