/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.fragments;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BVRInteractionOperator implements Enumerator
{
    ALT_LITERAL(0, "alt", "alt"),
    OPT_LITERAL(1, "opt", "opt"),
    PAR_LITERAL(2, "par", "par"),
    LOOP_LITERAL(3, "loop", "loop"),
    NEG_LITERAL(4, "neg", "neg");

    public static final int ALT = 0;
    public static final int OPT = 1;
    public static final int PAR = 2;
    public static final int LOOP = 3;
    public static final int NEG = 4;
    private static final BVRInteractionOperator[] VALUES_ARRAY;
    public static final List<BVRInteractionOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new BVRInteractionOperator[]{ALT_LITERAL, OPT_LITERAL, PAR_LITERAL, LOOP_LITERAL, NEG_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BVRInteractionOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BVRInteractionOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BVRInteractionOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BVRInteractionOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BVRInteractionOperator get(int value) {
        switch (value) {
            case 0: {
                return ALT_LITERAL;
            }
            case 1: {
                return OPT_LITERAL;
            }
            case 2: {
                return PAR_LITERAL;
            }
            case 3: {
                return LOOP_LITERAL;
            }
            case 4: {
                return NEG_LITERAL;
            }
        }
        return null;
    }

    private BVRInteractionOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static BVRInteractionOperator getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return BVRInteractionOperator.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

