/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BVRMessageSort implements Enumerator
{
    SYNCH_CALL_LITERAL(0, "synchCall", "synchCall"),
    SYNCH_SIGNAL_LITERAL(1, "synchSignal", "synchSignal"),
    ASYNCH_CALL_LITERAL(2, "asynchCall", "asynchCall"),
    ASYNCH_SIGNAL_LITERAL(3, "asynchSignal", "asynchSignal");

    public static final int SYNCH_CALL = 0;
    public static final int SYNCH_SIGNAL = 1;
    public static final int ASYNCH_CALL = 2;
    public static final int ASYNCH_SIGNAL = 3;
    private static final BVRMessageSort[] VALUES_ARRAY;
    public static final List<BVRMessageSort> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new BVRMessageSort[]{SYNCH_CALL_LITERAL, SYNCH_SIGNAL_LITERAL, ASYNCH_CALL_LITERAL, ASYNCH_SIGNAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BVRMessageSort get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BVRMessageSort result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BVRMessageSort getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BVRMessageSort result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BVRMessageSort get(int value) {
        switch (value) {
            case 0: {
                return SYNCH_CALL_LITERAL;
            }
            case 1: {
                return SYNCH_SIGNAL_LITERAL;
            }
            case 2: {
                return ASYNCH_CALL_LITERAL;
            }
            case 3: {
                return ASYNCH_SIGNAL_LITERAL;
            }
        }
        return null;
    }

    private BVRMessageSort(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static BVRMessageSort getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return BVRMessageSort.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

