/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TPFInvocationReason implements Enumerator
{
    UNKNOWN_LITERAL(0, "unknown", "unknown"),
    NONE_LITERAL(1, "none", "none"),
    SEE_DESCRIPTION_LITERAL(2, "seeDescription", "seeDescription"),
    PRECONDITION_NOT_MET_LITERAL(3, "preconditionNotMet", "preconditionNotMet"),
    NO_MATCHING_CONFIGURATION_LITERAL(4, "noMatchingConfiguration", "noMatchingConfiguration"),
    NO_BEHAVIOR_LITERAL(5, "noBehavior", "noBehavior"),
    DID_NOT_START_LITERAL(6, "didNotStart", "didNotStart");

    public static final int UNKNOWN = 0;
    public static final int NONE = 1;
    public static final int SEE_DESCRIPTION = 2;
    public static final int PRECONDITION_NOT_MET = 3;
    public static final int NO_MATCHING_CONFIGURATION = 4;
    public static final int NO_BEHAVIOR = 5;
    public static final int DID_NOT_START = 6;
    private static final TPFInvocationReason[] VALUES_ARRAY;
    public static final List<TPFInvocationReason> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new TPFInvocationReason[]{UNKNOWN_LITERAL, NONE_LITERAL, SEE_DESCRIPTION_LITERAL, PRECONDITION_NOT_MET_LITERAL, NO_MATCHING_CONFIGURATION_LITERAL, NO_BEHAVIOR_LITERAL, DID_NOT_START_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TPFInvocationReason get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFInvocationReason result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFInvocationReason getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFInvocationReason result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFInvocationReason get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN_LITERAL;
            }
            case 1: {
                return NONE_LITERAL;
            }
            case 2: {
                return SEE_DESCRIPTION_LITERAL;
            }
            case 3: {
                return PRECONDITION_NOT_MET_LITERAL;
            }
            case 4: {
                return NO_MATCHING_CONFIGURATION_LITERAL;
            }
            case 5: {
                return NO_BEHAVIOR_LITERAL;
            }
            case 6: {
                return DID_NOT_START_LITERAL;
            }
        }
        return null;
    }

    private TPFInvocationReason(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static TPFInvocationReason getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return TPFInvocationReason.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

