/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TPFInvocationStatus implements Enumerator
{
    UNATTEMPTED_LITERAL(0, "unattempted", "unattempted"),
    SUCCESSFUL_LITERAL(1, "successful", "successful"),
    UNSUCCESSFUL_LITERAL(2, "unsuccessful", "unsuccessful");

    public static final int UNATTEMPTED = 0;
    public static final int SUCCESSFUL = 1;
    public static final int UNSUCCESSFUL = 2;
    private static final TPFInvocationStatus[] VALUES_ARRAY;
    public static final List<TPFInvocationStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new TPFInvocationStatus[]{UNATTEMPTED_LITERAL, SUCCESSFUL_LITERAL, UNSUCCESSFUL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TPFInvocationStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFInvocationStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFInvocationStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFInvocationStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFInvocationStatus get(int value) {
        switch (value) {
            case 0: {
                return UNATTEMPTED_LITERAL;
            }
            case 1: {
                return SUCCESSFUL_LITERAL;
            }
            case 2: {
                return UNSUCCESSFUL_LITERAL;
            }
        }
        return null;
    }

    private TPFInvocationStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static TPFInvocationStatus getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return TPFInvocationStatus.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

