/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TPFSeverity implements Enumerator
{
    INFO_LITERAL(0, "info", "info"),
    ERROR_LITERAL(1, "error", "error"),
    WARNING_LITERAL(2, "warning", "warning");

    public static final int INFO = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    private static final TPFSeverity[] VALUES_ARRAY;
    public static final List<TPFSeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new TPFSeverity[]{INFO_LITERAL, ERROR_LITERAL, WARNING_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TPFSeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFSeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFSeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFSeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFSeverity get(int value) {
        switch (value) {
            case 0: {
                return INFO_LITERAL;
            }
            case 1: {
                return ERROR_LITERAL;
            }
            case 2: {
                return WARNING_LITERAL;
            }
        }
        return null;
    }

    private TPFSeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static TPFSeverity getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return TPFSeverity.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

