/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TPFVerdict implements Enumerator
{
    INCONCLUSIVE_LITERAL(0, "inconclusive", "inconclusive"),
    PASS_LITERAL(1, "pass", "pass"),
    FAIL_LITERAL(2, "fail", "fail"),
    ERROR_LITERAL(3, "error", "error");

    public static final int INCONCLUSIVE = 0;
    public static final int PASS = 1;
    public static final int FAIL = 2;
    public static final int ERROR = 3;
    private static final TPFVerdict[] VALUES_ARRAY;
    public static final List<TPFVerdict> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new TPFVerdict[]{INCONCLUSIVE_LITERAL, PASS_LITERAL, FAIL_LITERAL, ERROR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TPFVerdict get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFVerdict result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFVerdict getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFVerdict result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFVerdict get(int value) {
        switch (value) {
            case 0: {
                return INCONCLUSIVE_LITERAL;
            }
            case 1: {
                return PASS_LITERAL;
            }
            case 2: {
                return FAIL_LITERAL;
            }
            case 3: {
                return ERROR_LITERAL;
            }
        }
        return null;
    }

    private TPFVerdict(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static TPFVerdict getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return TPFVerdict.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

