/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.datapool.evaluator.DatapoolEvaluatorLiteral;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.eclipse.hyades.models.common.datapool.impl.Messages;

public class DatapoolUtil {
    private static IExtension[] dpEvaluatorExts;
    private static HashMap dpEvaluatorsMap;

    static {
        dpEvaluatorsMap = new HashMap();
    }

    private static IExtension[] getEvaluatorExts() {
        if (dpEvaluatorExts == null) {
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.models.datapool_evaluator");
            if (extPoint != null) {
                DPLLogImpl.log("ext point found!!!");
                dpEvaluatorExts = extPoint.getExtensions();
                DPLLogImpl.log("extensions.length: " + dpEvaluatorExts.length);
            } else {
                dpEvaluatorExts = new IExtension[0];
            }
        }
        return dpEvaluatorExts;
    }

    public static IDatapoolEvaluatorExt findDatapoolEvaluator(String tag) {
        try {
            IDatapoolEvaluatorExt evaluator = (IDatapoolEvaluatorExt)dpEvaluatorsMap.get(tag);
            if (evaluator != null) {
                return evaluator;
            }
            if (tag != null && tag.equals("Literal")) {
                Class<?> cls = Class.forName("org.eclipse.hyades.datapool.evaluator.DatapoolEvaluatorLiteral");
                evaluator = (DatapoolEvaluatorLiteral)cls.newInstance();
                dpEvaluatorsMap.put(tag, evaluator);
                return evaluator;
            }
            IExtension[] extensions = DatapoolUtil.getEvaluatorExts();
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                DPLLogImpl.log("   extension:" + currentExtension.getUniqueIdentifier());
                IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                DPLLogImpl.log("configElements.length : " + configElements.length);
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement currentConfigElement = configElements[j];
                    String currentTag = currentConfigElement.getAttribute("tag");
                    DPLLogImpl.log("Tag: " + currentTag);
                    DPLLogImpl.log("configElement: " + currentConfigElement.toString());
                    if (tag.equals(currentTag)) {
                        evaluator = (IDatapoolEvaluatorExt)currentConfigElement.createExecutableExtension("class");
                        dpEvaluatorsMap.put(tag, evaluator);
                        DPLLogImpl.log("evaluator: " + evaluator.toString());
                        return evaluator;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            DPLLogImpl.log(t.getMessage());
        }
        return null;
    }

    public static IDatapool createNewDatapool(String name, String description) {
        DPLDatapool datapool = Common_DatapoolFactory.eINSTANCE.createDPLDatapool();
        datapool.setName(name == null ? "" : name);
        if (description != null && description.trim().length() > 0) {
            datapool.setDescription(description);
        }
        DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
        datapool.setDatapoolSpec(datapoolSpec);
        return datapool;
    }

    public static String createUniqueECName(IDatapool datapool) {
        int suffix = datapool.getEquivalenceClassCount() + 1;
        String name = Messages.getString("DATAPOOL_EC_NAME", String.valueOf(suffix));
        while (!DatapoolUtil.isECNameUnique(name, datapool)) {
            name = Messages.getString("DATAPOOL_EC_NAME", String.valueOf(++suffix));
        }
        return name;
    }

    public static boolean isECNameUnique(String name, IDatapool datapool) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < datapool.getEquivalenceClassCount()) {
            if (name.equals(datapool.getEquivalenceClass(i).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String createUniqueVariableName(IDatapool datapool) {
        int counter = datapool.getVariableCount() + 1;
        String uniqueVariableName = Messages.getString("DATAPOOL_VARIABLE_NAME", String.valueOf(counter));
        while (!DatapoolUtil.isVariableNameUnique(uniqueVariableName, datapool)) {
            uniqueVariableName = Messages.getString("DATAPOOL_VARIABLE_NAME", String.valueOf(++counter));
        }
        return uniqueVariableName;
    }

    public static boolean isVariableNameUnique(String name, IDatapool datapool) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < datapool.getVariableCount()) {
            if (name.equals(datapool.getVariable(i).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void addEvaluator(String tag, String newEvalClassName) {
        try {
            Class<?> cls = Class.forName(newEvalClassName);
            IDatapoolEvaluatorExt newEval = (IDatapoolEvaluatorExt)cls.newInstance();
            dpEvaluatorsMap.put(tag, newEval);
            DPLLogImpl.log("Evaluator added to map: " + tag + " " + newEvalClassName);
        }
        catch (Throwable t) {
            DPLLogImpl.log("addEvaluator: " + t.getMessage());
        }
    }
}

