/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Vector;
import org.eclipse.hyades.models.common.util.ResourceUtil;

public class FileUtil {
    static File tempDir = null;

    public static synchronized File getTempDir() {
        if (tempDir == null) {
            try {
                File tempFile = File.createTempFile("test", "FileUtil");
                tempDir = tempFile.getParentFile();
                tempFile.delete();
            }
            catch (IOException e) {
                ResourceUtil.logError(e);
            }
        } else if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }

    public static boolean copyFile(String srcFile, String destFile) {
        try {
            FileUtil.copyFileSafe(srcFile, destFile);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void copyFileSafe(String srcFile, String destFile) throws IOException {
        FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
        FileChannel destChannel = new FileOutputStream(destFile).getChannel();
        long fileSize = srcChannel.size();
        long maxBuf = 0x2000000L;
        long bytesTransferred = 0L;
        long l = 0L;
        while (l < fileSize / maxBuf) {
            long startPos = bytesTransferred;
            destChannel.transferFrom(srcChannel, startPos, maxBuf);
            bytesTransferred += maxBuf;
            ++l;
        }
        if (fileSize % maxBuf != 0L) {
            long startPos = bytesTransferred;
            destChannel.transferFrom(srcChannel, startPos, fileSize % maxBuf);
            bytesTransferred += fileSize % maxBuf;
        }
        srcChannel.close();
        destChannel.close();
    }

    public static File[] listAllFiles(File srcDir) {
        Vector<File> files = new Vector<File>();
        File[] children = srcDir.listFiles();
        if (children == null) {
            return new File[0];
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isFile()) {
                files.add(children[i]);
            } else {
                File[] sub = FileUtil.listAllFiles(children[i]);
                int j = 0;
                while (j < sub.length) {
                    files.add(sub[j]);
                    ++j;
                }
            }
            ++i;
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean deltree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    FileUtil.deltree(children[i]);
                    ++i;
                }
            }
            return root.delete();
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println("FileUtil.getTempDir()=" + FileUtil.getTempDir());
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            FileUtil.getTempDir();
            ++i;
        }
        System.out.println("i=" + i + ", elapsedTime=" + (System.currentTimeMillis() - time));
    }
}

