/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ResourceCache {
    private Hashtable resourceMap;
    private static ResourceCache instance = null;

    public static ResourceCache getInstance() {
        if (instance == null) {
            instance = new ResourceCache();
            ResourceCache.instance.resourceMap = new Hashtable();
        }
        return instance;
    }

    private ResourceCache() {
    }

    public Resource getSharedResource(URI resourceURI) {
        ResourcePair pair = (ResourcePair)this.resourceMap.get(resourceURI);
        if (pair != null) {
            pair.incrementRefCount();
            return pair.getResource();
        }
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.getResource(resourceURI, true);
        if (resource != null) {
            this.resourceMap.put(resourceURI, new ResourcePair(resource));
        }
        return resource;
    }

    public ResourceSet createResourceSet() {
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                switch (msg.getEventType()) {
                    case 3: {
                        if (!(msg.getNewValue() instanceof Resource)) break;
                        ((Resource)msg.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)msg.getNewValue();
                        for (Object element : collection) {
                            if (!(element instanceof Resource)) continue;
                            ((Resource)element).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.eAdapters().add((Object)adapter);
        return resourceSet;
    }

    public Resource createSharedResource(URI resourceURI, ResourceSet resourceSet) {
        Resource newResource = resourceSet.createResource(resourceURI);
        if (newResource != null) {
            ResourcePair pair = new ResourcePair(newResource);
            this.resourceMap.put(resourceURI, pair);
        }
        return newResource;
    }

    public int getSharedResourceCount(URI resourceURI) {
        ResourcePair pair = (ResourcePair)this.resourceMap.get(resourceURI);
        if (pair != null) {
            return pair.getRefCount();
        }
        return 0;
    }

    public void releaseSharedResource(URI resourceURI) {
        ResourcePair pair = (ResourcePair)this.resourceMap.get(resourceURI);
        if (pair != null) {
            pair.decrementRefCount();
            if (pair.getRefCount() < 1) {
                this.resourceMap.remove(resourceURI);
                Resource resource = pair.getResource();
                ResourceSet rs = resource.getResourceSet();
                if (rs != null) {
                    rs.eAdapters().clear();
                }
                resource.unload();
            }
        }
    }

    private class ResourcePair {
        private Resource resource;
        private int refCount;

        public ResourcePair(Resource resource) {
            this.resource = resource;
            this.refCount = 1;
        }

        public void incrementRefCount() {
            ++this.refCount;
        }

        public void decrementRefCount() {
            --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

