/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TRCGCRootType implements Enumerator
{
    UNKNOWN_LITERAL(-1, "UNKNOWN", "UNKNOWN"),
    JNI_GLOBAL_LITERAL(1, "JNI_GLOBAL", "JNI_GLOBAL"),
    JNI_LOCAL_LITERAL(2, "JNI_LOCAL", "JNI_LOCAL"),
    JAVA_FRAME_LITERAL(3, "JAVA_FRAME", "JAVA_FRAME"),
    NATIVE_STACK_LITERAL(4, "NATIVE_STACK", "NATIVE_STACK"),
    STICKY_CLASS_LITERAL(5, "STICKY_CLASS", "STICKY_CLASS"),
    THREAD_BLOCK_LITERAL(6, "THREAD_BLOCK", "THREAD_BLOCK"),
    MONITOR_USED_LITERAL(7, "MONITOR_USED", "MONITOR_USED");

    public static final int UNKNOWN = -1;
    public static final int JNI_GLOBAL = 1;
    public static final int JNI_LOCAL = 2;
    public static final int JAVA_FRAME = 3;
    public static final int NATIVE_STACK = 4;
    public static final int STICKY_CLASS = 5;
    public static final int THREAD_BLOCK = 6;
    public static final int MONITOR_USED = 7;
    private static final TRCGCRootType[] VALUES_ARRAY;
    public static final List<TRCGCRootType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TRCGCRootType[]{UNKNOWN_LITERAL, JNI_GLOBAL_LITERAL, JNI_LOCAL_LITERAL, JAVA_FRAME_LITERAL, NATIVE_STACK_LITERAL, STICKY_CLASS_LITERAL, THREAD_BLOCK_LITERAL, MONITOR_USED_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TRCGCRootType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCGCRootType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCGCRootType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCGCRootType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCGCRootType get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN_LITERAL;
            }
            case 1: {
                return JNI_GLOBAL_LITERAL;
            }
            case 2: {
                return JNI_LOCAL_LITERAL;
            }
            case 3: {
                return JAVA_FRAME_LITERAL;
            }
            case 4: {
                return NATIVE_STACK_LITERAL;
            }
            case 5: {
                return STICKY_CLASS_LITERAL;
            }
            case 6: {
                return THREAD_BLOCK_LITERAL;
            }
            case 7: {
                return MONITOR_USED_LITERAL;
            }
        }
        return null;
    }

    private TRCGCRootType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

