/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TRCMethodProperties implements Enumerator
{
    JAVA_NATIVE_LITERAL(1, "JAVA_NATIVE", "JAVA_NATIVE"),
    JAVA_SYNCHRONIZED_LITERAL(2, "JAVA_SYNCHRONIZED", "JAVA_SYNCHRONIZED"),
    JAVA_PUBLIC_LITERAL(4, "JAVA_PUBLIC", "JAVA_PUBLIC"),
    JAVA_PRIVATE_LITERAL(8, "JAVA_PRIVATE", "JAVA_PRIVATE"),
    JAVA_PROTECTED_LITERAL(16, "JAVA_PROTECTED", "JAVA_PROTECTED"),
    JAVA_DEFAULT_VISIBILITY_LITERAL(32, "JAVA_DEFAULT_VISIBILITY", "JAVA_DEFAULT_VISIBILITY"),
    JAVA_STATIC_LITERAL(64, "JAVA_STATIC", "JAVA_STATIC"),
    JAVA_CONSTRUCTOR_LITERAL(128, "JAVA_CONSTRUCTOR", "JAVA_CONSTRUCTOR"),
    JAVA_ABSTRACT_LITERAL(256, "JAVA_ABSTRACT", "JAVA_ABSTRACT"),
    JAVA_FINALIZER_LITERAL(512, "JAVA_FINALIZER", "JAVA_FINALIZER");

    public static final int JAVA_NATIVE = 1;
    public static final int JAVA_SYNCHRONIZED = 2;
    public static final int JAVA_PUBLIC = 4;
    public static final int JAVA_PRIVATE = 8;
    public static final int JAVA_PROTECTED = 16;
    public static final int JAVA_DEFAULT_VISIBILITY = 32;
    public static final int JAVA_STATIC = 64;
    public static final int JAVA_CONSTRUCTOR = 128;
    public static final int JAVA_ABSTRACT = 256;
    public static final int JAVA_FINALIZER = 512;
    private static final TRCMethodProperties[] VALUES_ARRAY;
    public static final List<TRCMethodProperties> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TRCMethodProperties[]{JAVA_NATIVE_LITERAL, JAVA_SYNCHRONIZED_LITERAL, JAVA_PUBLIC_LITERAL, JAVA_PRIVATE_LITERAL, JAVA_PROTECTED_LITERAL, JAVA_DEFAULT_VISIBILITY_LITERAL, JAVA_STATIC_LITERAL, JAVA_CONSTRUCTOR_LITERAL, JAVA_ABSTRACT_LITERAL, JAVA_FINALIZER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TRCMethodProperties get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCMethodProperties result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCMethodProperties getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCMethodProperties result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCMethodProperties get(int value) {
        switch (value) {
            case 1: {
                return JAVA_NATIVE_LITERAL;
            }
            case 2: {
                return JAVA_SYNCHRONIZED_LITERAL;
            }
            case 4: {
                return JAVA_PUBLIC_LITERAL;
            }
            case 8: {
                return JAVA_PRIVATE_LITERAL;
            }
            case 16: {
                return JAVA_PROTECTED_LITERAL;
            }
            case 32: {
                return JAVA_DEFAULT_VISIBILITY_LITERAL;
            }
            case 64: {
                return JAVA_STATIC_LITERAL;
            }
            case 128: {
                return JAVA_CONSTRUCTOR_LITERAL;
            }
            case 256: {
                return JAVA_ABSTRACT_LITERAL;
            }
            case 512: {
                return JAVA_FINALIZER_LITERAL;
            }
        }
        return null;
    }

    private TRCMethodProperties(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static String getString(String key) {
        return key;
    }

    public static TRCMethodProperties getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return VALUES_ARRAY[0];
    }

    public String getLabel() {
        try {
            return TRCMethodProperties.getString(String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName());
        }
        catch (RuntimeException runtimeException) {
            return this.getName();
        }
    }
}

