/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TRCObjectValuePosition implements Enumerator
{
    BEFORE_LITERAL(0, "before", "before"),
    AFTER_LITERAL(1, "after", "after"),
    EXIT_LITERAL(2, "exit", "exit");

    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int EXIT = 2;
    private static final TRCObjectValuePosition[] VALUES_ARRAY;
    public static final List<TRCObjectValuePosition> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TRCObjectValuePosition[]{BEFORE_LITERAL, AFTER_LITERAL, EXIT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TRCObjectValuePosition get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCObjectValuePosition result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCObjectValuePosition getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCObjectValuePosition result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCObjectValuePosition get(int value) {
        switch (value) {
            case 0: {
                return BEFORE_LITERAL;
            }
            case 1: {
                return AFTER_LITERAL;
            }
            case 2: {
                return EXIT_LITERAL;
            }
        }
        return null;
    }

    private TRCObjectValuePosition(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

