/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TRCPrimitiveType implements Enumerator
{
    JAVA_REFERENCE_LITERAL(1, "JAVA_REFERENCE", "JAVA_REFERENCE"),
    JAVA_BOOLEAN_LITERAL(1, "JAVA_BOOLEAN", "JAVA_BOOLEAN"),
    JAVA_BYTE_LITERAL(2, "JAVA_BYTE", "JAVA_BYTE"),
    JAVA_CHAR_LITERAL(3, "JAVA_CHAR", "JAVA_CHAR"),
    JAVA_SHORT_LITERAL(4, "JAVA_SHORT", "JAVA_SHORT"),
    JAVA_INT_LITERAL(5, "JAVA_INT", "JAVA_INT"),
    JAVA_LONG_LITERAL(6, "JAVA_LONG", "JAVA_LONG"),
    JAVA_FLOAT_LITERAL(7, "JAVA_FLOAT", "JAVA_FLOAT"),
    JAVA_DOUBLE_LITERAL(8, "JAVA_DOUBLE", "JAVA_DOUBLE");

    public static final int JAVA_REFERENCE = 1;
    public static final int JAVA_BOOLEAN = 1;
    public static final int JAVA_BYTE = 2;
    public static final int JAVA_CHAR = 3;
    public static final int JAVA_SHORT = 4;
    public static final int JAVA_INT = 5;
    public static final int JAVA_LONG = 6;
    public static final int JAVA_FLOAT = 7;
    public static final int JAVA_DOUBLE = 8;
    private static final TRCPrimitiveType[] VALUES_ARRAY;
    public static final List<TRCPrimitiveType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TRCPrimitiveType[]{JAVA_REFERENCE_LITERAL, JAVA_BOOLEAN_LITERAL, JAVA_BYTE_LITERAL, JAVA_CHAR_LITERAL, JAVA_SHORT_LITERAL, JAVA_INT_LITERAL, JAVA_LONG_LITERAL, JAVA_FLOAT_LITERAL, JAVA_DOUBLE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TRCPrimitiveType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCPrimitiveType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCPrimitiveType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCPrimitiveType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCPrimitiveType get(int value) {
        switch (value) {
            case 1: {
                return JAVA_REFERENCE_LITERAL;
            }
            case 2: {
                return JAVA_BYTE_LITERAL;
            }
            case 3: {
                return JAVA_CHAR_LITERAL;
            }
            case 4: {
                return JAVA_SHORT_LITERAL;
            }
            case 5: {
                return JAVA_INT_LITERAL;
            }
            case 6: {
                return JAVA_LONG_LITERAL;
            }
            case 7: {
                return JAVA_FLOAT_LITERAL;
            }
            case 8: {
                return JAVA_DOUBLE_LITERAL;
            }
        }
        return null;
    }

    private TRCPrimitiveType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

