/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCLanguageElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TRCMethodImpl
extends TRCLanguageElementImpl
implements TRCMethod {
    private TRCMethodSnapshot _currentSnapshot;
    private TRCMethodSnapshot _previousSnapshot;
    protected static final int ID_EDEFAULT = 0;
    protected int id = 0;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String SIGNATURE_EDEFAULT = null;
    protected String signature = SIGNATURE_EDEFAULT;
    protected static final int MODIFIER_EDEFAULT = 0;
    protected int modifier = 0;
    protected static final TRCSignatureNotation NOTATION_EDEFAULT = TRCSignatureNotation.JNI_LITERAL;
    protected TRCSignatureNotation notation = NOTATION_EDEFAULT;
    protected static final int LINE_NO_EDEFAULT = 0;
    protected int lineNo = 0;
    protected static final int LINE_COUNT_EDEFAULT = 0;
    protected int lineCount = 0;
    protected static final double BASE_TIME_EDEFAULT = 0.0;
    protected double baseTime = 0.0;
    protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;
    protected double cumulativeTime = 0.0;
    protected static final int CALLS_EDEFAULT = 0;
    protected int calls = 0;
    protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;
    protected double totalCpuTime = 0.0;
    protected EList<TRCMethodInvocation> invocations;

    @Override
    public int computeDelta(IDelta delta) {
        TRCMethodSnapshot delta1 = (TRCMethodSnapshot)delta;
        if (this._currentSnapshot == null || this._previousSnapshot == null) {
            delta1.baseTime = 0.0;
            delta1.calls = 0;
            delta1.cumulativeTime = 0.0;
            delta1.totalCpuTime = 0.0;
            return -1;
        }
        delta1.baseTime = this._currentSnapshot.baseTime - this._previousSnapshot.baseTime;
        delta1.calls = this._currentSnapshot.calls - this._previousSnapshot.calls;
        delta1.cumulativeTime = this._currentSnapshot.cumulativeTime - this._previousSnapshot.cumulativeTime;
        delta1.totalCpuTime = this._currentSnapshot.totalCpuTime - this._previousSnapshot.totalCpuTime;
        return 1;
    }

    @Override
    public int computeDelta(IDelta delta, int featureID) {
        TRCMethodSnapshot delta1 = (TRCMethodSnapshot)delta;
        if (this._currentSnapshot == null || this._previousSnapshot == null) {
            switch (featureID) {
                case 9: {
                    delta1.baseTime = 0.0;
                    break;
                }
                case 10: {
                    delta1.cumulativeTime = 0.0;
                    break;
                }
                case 11: {
                    delta1.calls = 0;
                }
                case 12: {
                    delta1.totalCpuTime = 0.0;
                }
            }
            return -1;
        }
        switch (featureID) {
            case 9: {
                delta1.baseTime = this._currentSnapshot.baseTime - this._previousSnapshot.baseTime;
                break;
            }
            case 10: {
                delta1.cumulativeTime = this._currentSnapshot.cumulativeTime - this._previousSnapshot.cumulativeTime;
                break;
            }
            case 11: {
                delta1.calls = this._currentSnapshot.calls - this._previousSnapshot.calls;
            }
            case 12: {
                delta1.totalCpuTime = this._currentSnapshot.totalCpuTime - this._previousSnapshot.totalCpuTime;
            }
        }
        return 1;
    }

    @Override
    public void removeSnapshot() {
        this._currentSnapshot = null;
        this._previousSnapshot = null;
    }

    @Override
    public ISnapshot retrieveSnapshot() {
        if (this._currentSnapshot == null) {
            this.takeSnapshot();
        }
        return this._currentSnapshot;
    }

    @Override
    public void takeSnapshot() {
        TRCMethodSnapshot temp = this._previousSnapshot;
        this._previousSnapshot = this._currentSnapshot;
        this._currentSnapshot = temp;
        if (this._currentSnapshot == null) {
            this._currentSnapshot = new TRCMethodSnapshot();
        }
        this._currentSnapshot.baseTime = this.baseTime;
        this._currentSnapshot.calls = this.calls;
        this._currentSnapshot.cumulativeTime = this.cumulativeTime;
        this._currentSnapshot.totalCpuTime = this.totalCpuTime;
    }

    protected TRCMethodImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TracePackage.Literals.TRC_METHOD;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int newId) {
        int oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldId, this.id));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(String newSignature) {
        String oldSignature = this.signature;
        this.signature = newSignature;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSignature, (Object)this.signature));
        }
    }

    @Override
    public int getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(int newModifier) {
        int oldModifier = this.modifier;
        this.modifier = newModifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldModifier, this.modifier));
        }
    }

    @Override
    public TRCSignatureNotation getNotation() {
        return this.notation;
    }

    @Override
    public void setNotation(TRCSignatureNotation newNotation) {
        TRCSignatureNotation oldNotation = this.notation;
        TRCSignatureNotation tRCSignatureNotation = this.notation = newNotation == null ? NOTATION_EDEFAULT : newNotation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldNotation, (Object)this.notation));
        }
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    @Override
    public void setLineNo(int newLineNo) {
        int oldLineNo = this.lineNo;
        this.lineNo = newLineNo;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldLineNo, this.lineNo));
        }
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public void setLineCount(int newLineCount) {
        int oldLineCount = this.lineCount;
        this.lineCount = newLineCount;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldLineCount, this.lineCount));
        }
    }

    @Override
    public double getBaseTime() {
        return this.baseTime;
    }

    @Override
    public void setBaseTime(double newBaseTime) {
        double oldBaseTime = this.baseTime;
        this.baseTime = newBaseTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldBaseTime, this.baseTime));
        }
    }

    @Override
    public double getCumulativeTime() {
        return this.cumulativeTime;
    }

    @Override
    public void setCumulativeTime(double newCumulativeTime) {
        double oldCumulativeTime = this.cumulativeTime;
        this.cumulativeTime = newCumulativeTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldCumulativeTime, this.cumulativeTime));
        }
    }

    @Override
    public int getCalls() {
        return this.calls;
    }

    @Override
    public void setCalls(int newCalls) {
        int oldCalls = this.calls;
        this.calls = newCalls;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldCalls, this.calls));
        }
    }

    @Override
    public double getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @Override
    public void setTotalCpuTime(double newTotalCpuTime) {
        double oldTotalCpuTime = this.totalCpuTime;
        this.totalCpuTime = newTotalCpuTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldTotalCpuTime, this.totalCpuTime));
        }
    }

    @Override
    public TRCClass getDefiningClass() {
        if (this.eContainerFeatureID() != 13) {
            return null;
        }
        return (TRCClass)this.eContainer();
    }

    public NotificationChain basicSetDefiningClass(TRCClass newDefiningClass, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newDefiningClass, 13, msgs);
        return msgs;
    }

    @Override
    public void setDefiningClass(TRCClass newDefiningClass) {
        if (newDefiningClass != this.eInternalContainer() || this.eContainerFeatureID() != 13 && newDefiningClass != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newDefiningClass)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newDefiningClass != null) {
                msgs = ((InternalEObject)newDefiningClass).eInverseAdd((InternalEObject)this, 23, TRCClass.class, msgs);
            }
            if ((msgs = this.basicSetDefiningClass(newDefiningClass, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newDefiningClass, (Object)newDefiningClass));
        }
    }

    @Override
    public EList<TRCMethodInvocation> getInvocations() {
        if (this.invocations == null) {
            this.invocations = new EObjectWithInverseEList(TRCMethodInvocation.class, (InternalEObject)this, 14, 0);
        }
        return this.invocations;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetDefiningClass((TRCClass)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getInvocations()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return this.basicSetDefiningClass(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getInvocations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 13: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 23, TRCClass.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getId();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getSignature();
            }
            case 5: {
                return this.getModifier();
            }
            case 6: {
                return this.getNotation();
            }
            case 7: {
                return this.getLineNo();
            }
            case 8: {
                return this.getLineCount();
            }
            case 9: {
                return this.getBaseTime();
            }
            case 10: {
                return this.getCumulativeTime();
            }
            case 11: {
                return this.getCalls();
            }
            case 12: {
                return this.getTotalCpuTime();
            }
            case 13: {
                return this.getDefiningClass();
            }
            case 14: {
                return this.getInvocations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setId((Integer)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.setSignature((String)newValue);
                return;
            }
            case 5: {
                this.setModifier((Integer)newValue);
                return;
            }
            case 6: {
                this.setNotation((TRCSignatureNotation)((Object)newValue));
                return;
            }
            case 7: {
                this.setLineNo((Integer)newValue);
                return;
            }
            case 8: {
                this.setLineCount((Integer)newValue);
                return;
            }
            case 9: {
                this.setBaseTime((Double)newValue);
                return;
            }
            case 10: {
                this.setCumulativeTime((Double)newValue);
                return;
            }
            case 11: {
                this.setCalls((Integer)newValue);
                return;
            }
            case 12: {
                this.setTotalCpuTime((Double)newValue);
                return;
            }
            case 13: {
                this.setDefiningClass((TRCClass)newValue);
                return;
            }
            case 14: {
                this.getInvocations().clear();
                this.getInvocations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setId(0);
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setSignature(SIGNATURE_EDEFAULT);
                return;
            }
            case 5: {
                this.setModifier(0);
                return;
            }
            case 6: {
                this.setNotation(NOTATION_EDEFAULT);
                return;
            }
            case 7: {
                this.setLineNo(0);
                return;
            }
            case 8: {
                this.setLineCount(0);
                return;
            }
            case 9: {
                this.setBaseTime(0.0);
                return;
            }
            case 10: {
                this.setCumulativeTime(0.0);
                return;
            }
            case 11: {
                this.setCalls(0);
                return;
            }
            case 12: {
                this.setTotalCpuTime(0.0);
                return;
            }
            case 13: {
                this.setDefiningClass(null);
                return;
            }
            case 14: {
                this.getInvocations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.id != 0;
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return SIGNATURE_EDEFAULT == null ? this.signature != null : !SIGNATURE_EDEFAULT.equals(this.signature);
            }
            case 5: {
                return this.modifier != 0;
            }
            case 6: {
                return this.notation != NOTATION_EDEFAULT;
            }
            case 7: {
                return this.lineNo != 0;
            }
            case 8: {
                return this.lineCount != 0;
            }
            case 9: {
                return this.baseTime != 0.0;
            }
            case 10: {
                return this.cumulativeTime != 0.0;
            }
            case 11: {
                return this.calls != 0;
            }
            case 12: {
                return this.totalCpuTime != 0.0;
            }
            case 13: {
                return this.getDefiningClass() != null;
            }
            case 14: {
                return this.invocations != null && !this.invocations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(", name: ");
        result.append(this.name);
        result.append(", signature: ");
        result.append(this.signature);
        result.append(", modifier: ");
        result.append(this.modifier);
        result.append(", notation: ");
        result.append((Object)this.notation);
        result.append(", lineNo: ");
        result.append(this.lineNo);
        result.append(", lineCount: ");
        result.append(this.lineCount);
        result.append(", baseTime: ");
        result.append(this.baseTime);
        result.append(", cumulativeTime: ");
        result.append(this.cumulativeTime);
        result.append(", calls: ");
        result.append(this.calls);
        result.append(", totalCpuTime: ");
        result.append(this.totalCpuTime);
        result.append(')');
        return result.toString();
    }

    public static class TRCMethodSnapshot
    implements IDelta,
    ISnapshot {
        protected double baseTime = 0.0;
        protected int calls = 0;
        protected double cumulativeTime = 0.0;
        protected double totalCpuTime = 0.0;

        public Object get(int featureID) {
            switch (featureID) {
                case 9: {
                    return new Double(this.getBaseTime());
                }
                case 10: {
                    return new Double(this.getCumulativeTime());
                }
                case 11: {
                    return new Integer(this.getCalls());
                }
                case 12: {
                    return new Double(this.getTotalCpuTime());
                }
            }
            return null;
        }

        public double getBaseTime() {
            return this.baseTime;
        }

        public int getCalls() {
            return this.calls;
        }

        public double getCumulativeTime() {
            return this.cumulativeTime;
        }

        public double getTotalCpuTime() {
            return this.totalCpuTime;
        }
    }
}

