/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.pde.ui.launcher.EquinoxLaunchConfiguration;
import org.eclipse.tptp.platform.integration.pde.internal.util.PDEIntegrationLauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractProcessLauncher;

public abstract class AbstractEquinoxDelegate
extends AbstractProcessLauncher {
    protected EquinoxLaunchConfigurationExtended equinoxLaunchConfiguration = new EquinoxLaunchConfigurationExtended();

    public AbstractEquinoxDelegate(String agentName, String agentType) {
        super(agentName, agentType);
    }

    public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.equinoxLaunchConfiguration.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        this.equinoxLaunchConfiguration.setConfigurationDirectory(null);
        this.equinoxLaunchConfiguration.synchronizeManifests(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.equinoxLaunchConfiguration.manageLaunch(launch);
        super.preLaunch(configuration, mode, launch, monitor);
    }

    protected String getWorkingDirectory(ILaunchConfiguration conf) {
        return null;
    }

    protected String getProgramArguments(ILaunchConfiguration conf) {
        try {
            return LauncherUtility.convertToString((String[])this.equinoxLaunchConfiguration.getProgramArguments(conf));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getMainTypeName(ILaunchConfiguration conf) {
        return "org.eclipse.core.launcher.Main";
    }

    protected String getVMArguments(ILaunchConfiguration conf) {
        try {
            return LauncherUtility.convertToString((String[])new ExecutionArguments(conf.getAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", ""), "").getVMArgumentsArray());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String[] getClasspath(ILaunchConfiguration conf) {
        try {
            return this.equinoxLaunchConfiguration.getClasspath(conf);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ArrayList getLaunchTypeWorkspaceFilters(ILaunchConfiguration config) throws CoreException {
        return PDEIntegrationLauncherUtility.getWorkspacePluginFilters(config, LauncherUtility.getActiveWorkingSets());
    }

    private class EquinoxLaunchConfigurationExtended
    extends EquinoxLaunchConfiguration {
        private EquinoxLaunchConfigurationExtended() {
        }

        public void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            super.preLaunchCheck(configuration, launch, monitor);
        }

        public void setConfigurationDirectory(File directory) {
            this.fConfigDir = directory;
        }

        public File getConfigDir(ILaunchConfiguration configuration) {
            return super.getConfigDir(configuration);
        }

        public void manageLaunch(ILaunch launch) {
            super.manageLaunch(launch);
        }

        public void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
            super.synchronizeManifests(configuration, monitor);
        }
    }
}

