/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.ui.launcher.EclipseApplicationLaunchConfiguration;
import org.eclipse.tptp.platform.integration.pde.internal.util.PDEIntegrationLauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractProcessLauncher;

public abstract class AbstractRuntimeWorkbenchDelegate
extends AbstractProcessLauncher {
    protected EclipseConfigurationExtended runtimeConfiguration = new EclipseConfigurationExtended();

    public AbstractRuntimeWorkbenchDelegate(String agentName, String agentType) {
        super(agentName, agentType);
    }

    public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.runtimeConfiguration.setConfigurationDirectory(null);
        this.runtimeConfiguration.promptToClear(configuration, monitor);
        launch.setAttribute("configLocation", this.runtimeConfiguration.getConfigDir(configuration).toString());
        this.runtimeConfiguration.preLaunchCheck(configuration, launch, monitor);
        super.preLaunch(configuration, mode, launch, monitor);
    }

    protected String getWorkingDirectory(ILaunchConfiguration conf) {
        return null;
    }

    protected String getProgramArguments(ILaunchConfiguration conf) {
        try {
            return LauncherUtility.convertToString((String[])this.runtimeConfiguration.getProgramArguments(conf));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getMainTypeName(ILaunchConfiguration conf) {
        return "org.eclipse.core.launcher.Main";
    }

    protected String getVMArguments(ILaunchConfiguration conf) {
        try {
            String[] args = this.runtimeConfiguration.getVMArguments(conf);
            return LauncherUtility.convertToString((String[])args);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String[] getClasspath(ILaunchConfiguration conf) {
        try {
            return this.runtimeConfiguration.getClasspath(conf);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ArrayList getLaunchTypeWorkspaceFilters(ILaunchConfiguration config) throws CoreException {
        return PDEIntegrationLauncherUtility.getWorkspacePluginFilters(config, LauncherUtility.getActiveWorkingSets());
    }

    private class EclipseConfigurationExtended
    extends EclipseApplicationLaunchConfiguration {
        private EclipseConfigurationExtended() {
        }

        public void setConfigurationDirectory(File directory) {
            this.fConfigDir = directory;
        }

        public File getConfigDir(ILaunchConfiguration configuration) {
            return super.getConfigDir(configuration);
        }

        public void promptToClear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
            super.clear(configuration, monitor);
        }

        public void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            super.preLaunchCheck(configuration, launch, monitor);
        }
    }
}

