/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.dialog;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IFilter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestOnlyFilter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestProvider;
import org.eclipse.hyades.test.ui.navigator.IProxy;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InvokedTestSelectionDialog
extends Dialog
implements IDoubleClickListener,
ISelectionChangedListener {
    protected static final int HELP_DLG_CONTROL = 1;
    protected static final int HELP_LOCAL_TEST_CASES_CONTROL = 2;
    protected static final int HELP_TESTS_CONTROL = 3;
    private ITestSuite testSuite;
    private Collection tests;
    private TableViewer localTestCasesTableViewer;
    private TreeViewer testsTreeViewer;
    private String title;
    private String tableLabel;
    private String treeLabel;
    private boolean singleSelection;
    private ITypeValidator typeValidator;

    public InvokedTestSelectionDialog(Shell parentShell, ITestSuite testSuite, String title, String tableLabel, String treeLabel, boolean singleSelection) {
        super(parentShell);
        IAssociationDescriptor associationDescriptor;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.testSuite = testSuite;
        this.title = title;
        this.tableLabel = tableLabel;
        this.treeLabel = treeLabel;
        this.singleSelection = singleSelection;
        this.tests = new ArrayList();
        String type = testSuite.getType();
        if (type != null && (associationDescriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators").getDefaultAssociationDescriptor(type)) != null) {
            this.typeValidator = (ITypeValidator)associationDescriptor.createImplementationClassInstance();
        }
    }

    public void setTest(ITest test) {
        this.tests.clear();
        if (test instanceof ITestCase && ((ITestCase)test).getOwner().equals(this.getTestSuite())) {
            this.tests.add(test);
        } else if (test instanceof IAdaptable) {
            this.tests.add(((IAdaptable)test).getAdapter(IProxy.class));
        }
        this.selectTest(this.tests);
    }

    public Collection getTests() {
        ArrayList ret = new ArrayList(this.tests.size());
        for (Object obj : this.tests) {
            ITestSuiteProxyNode proxy;
            if (obj instanceof ITestCase) {
                ret.add(obj);
                continue;
            }
            if (obj instanceof ITestSuiteProxyNode) {
                proxy = (ITestSuiteProxyNode)obj;
                ret.add(proxy.getTestSuite());
                continue;
            }
            if (!(obj instanceof ITestCaseProxyNode)) continue;
            proxy = (ITestCaseProxyNode)obj;
            ret.add(proxy.getTestCase());
        }
        return ret;
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    protected ITypeValidator getTypeValidator() {
        return this.typeValidator;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        this.localTestCasesTableViewer.setInput((Object)this.testSuite);
        if (this.testsTreeViewer != null) {
            this.testsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        this.selectTest(this.tests);
        this.registerHelp(1, control);
        this.registerHelp(2, this.localTestCasesTableViewer.getControl());
        if (this.testsTreeViewer != null) {
            this.registerHelp(3, this.testsTreeViewer.getControl());
        }
        return control;
    }

    protected void registerHelp(int flag, Object object) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        superComposite.setLayoutData((Object)gridData);
        this.createLocalTestCasesControl(superComposite);
        if (this.getTypeValidator() != null) {
            this.createTestControl(superComposite);
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        return superComposite;
    }

    protected void selectTest(Collection tests) {
        if (this.localTestCasesTableViewer == null) {
            return;
        }
        if (tests != null) {
            for (Object obj : tests) {
                if (obj instanceof ITestCase && ((ITestCase)obj).getOwner() == this.testSuite) {
                    this.localTestCasesTableViewer.setSelection((ISelection)new StructuredSelection(obj), true);
                    continue;
                }
                if (!(obj instanceof IProxy) || this.testsTreeViewer == null) continue;
                TestProvider testProvider = (TestProvider)this.testsTreeViewer.getContentProvider();
                IProxyNode proxy = testProvider.getFileProxyManager().getCorrespondingProxy(obj);
                IProject project = proxy.getUnderlyingResource().getProject();
                testProvider.getChildren((Object)project);
                this.testsTreeViewer.setSelection((ISelection)new StructuredSelection((Object)proxy), true);
            }
        } else {
            this.localTestCasesTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            if (this.testsTreeViewer != null) {
                this.testsTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    protected void createLocalTestCasesControl(Composite parent) {
        if (this.tableLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.tableLabel);
        }
        int selection = this.singleSelection ? 4 : 2;
        this.localTestCasesTableViewer = new TableViewer(parent, selection | 0x100 | 0x200 | 0x800);
        this.localTestCasesTableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.localTestCasesTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.getTypeValidator() != null) {
            GridData gridData = GridDataUtil.createHorizontalFill();
            gridData.grabExcessVerticalSpace = false;
            gridData.heightHint = 100;
            this.localTestCasesTableViewer.getControl().setLayoutData((Object)gridData);
        } else {
            this.localTestCasesTableViewer.getControl().setLayoutData((Object)GridDataUtil.createFill());
        }
        IStructuredContentProvider tableViewContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (InvokedTestSelectionDialog.this.getTestSuite() != null) {
                    return InvokedTestSelectionDialog.this.getTestSuite().getITestCases().toArray();
                }
                return new Object[0];
            }
        };
        this.localTestCasesTableViewer.setContentProvider((IContentProvider)tableViewContentProvider);
        this.localTestCasesTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class));
    }

    protected void createTestControl(Composite parent) {
        if (this.treeLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.treeLabel);
        }
        int selection = this.singleSelection ? 4 : 2;
        this.testsTreeViewer = new TreeViewer(parent, selection | 0x100 | 0x200 | 0x800);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 220;
        this.testsTreeViewer.getControl().setLayoutData((Object)gridData);
        this.testsTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.testsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        final IProxy testSuiteProxy = (IProxy)((IAdaptable)this.getTestSuite()).getAdapter(IProxy.class);
        TestOnlyFilter filter = new TestOnlyFilter(){

            public boolean satisfies(IProxyNode node) {
                if (node instanceof ITestSuiteProxyNode) {
                    if (testSuiteProxy.equals(node)) {
                        return false;
                    }
                    String type = ((ITestSuiteProxyNode)node).getType();
                    return InvokedTestSelectionDialog.this.getTypeValidator().isValidType(type);
                }
                return super.satisfies(node);
            }

            public boolean satisfies(String type) {
                return InvokedTestSelectionDialog.this.getTypeValidator().isValidType(type);
            }

            public boolean satisfiesChildren(IProxyNode node) {
                return true;
            }
        };
        final TestProvider testProvider = new TestProvider((IFilter)filter, false);
        this.testsTreeViewer.setContentProvider((IContentProvider)testProvider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.testsTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)testProvider, decorator));
        this.testsTreeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                testProvider.dispose();
            }
        });
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.processSelection()) {
            this.okPressed();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.processSelection();
    }

    protected boolean processSelection() {
        this.tests.clear();
        this.processSelection((StructuredViewer)this.localTestCasesTableViewer);
        this.processSelection((StructuredViewer)this.testsTreeViewer);
        boolean isEnabled = this.tests.size() > 0;
        this.getButton(0).setEnabled(isEnabled);
        return isEnabled;
    }

    private void processSelection(StructuredViewer structuredViewer) {
        IStructuredSelection structuredSelection = (IStructuredSelection)structuredViewer.getSelection();
        if (!structuredSelection.isEmpty()) {
            for (Object object : structuredSelection) {
                if (!(object instanceof ITestSuiteProxyNode) && !(object instanceof ITestCaseProxyNode) && !(object instanceof ITestCase)) continue;
                this.tests.add(object);
            }
        }
    }
}

