/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.model.ui.EMFContentProvider;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OldInvokedTestSelectionDialog
extends Dialog
implements IDisposable,
IDoubleClickListener,
ISelectionChangedListener {
    protected static final int HELP_DLG_CONTROL = 1;
    protected static final int HELP_LOCAL_TEST_CASES_CONTROL = 2;
    protected static final int HELP_TESTS_CONTROL = 3;
    private ITestSuite testSuite;
    private Collection tests;
    private TableViewer localTestCasesTableViewer;
    private TreeViewer testsTreeViewer;
    private ResourceSet testsResourceSet;
    private List loadedEObjects;
    private String title;
    private String tableLabel;
    private String treeLabel;
    private boolean singleSelection;
    private ITypeValidator typeValidator;

    public OldInvokedTestSelectionDialog(Shell parentShell, ITestSuite testSuite, String title, String tableLabel, String treeLabel, boolean singleSelection) {
        super(parentShell);
        IAssociationDescriptor associationDescriptor;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.testSuite = testSuite;
        this.title = title;
        this.tableLabel = tableLabel;
        this.treeLabel = treeLabel;
        this.singleSelection = singleSelection;
        this.tests = new ArrayList();
        String type = testSuite.getType();
        if (type != null && (associationDescriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators").getDefaultAssociationDescriptor(type)) != null) {
            this.typeValidator = (ITypeValidator)associationDescriptor.createImplementationClassInstance();
        }
    }

    public void dispose() {
        this.testsResourceSet = null;
        if (this.localTestCasesTableViewer != null) {
            this.localTestCasesTableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.localTestCasesTableViewer.removeDoubleClickListener((IDoubleClickListener)this);
            this.localTestCasesTableViewer = null;
        }
        if (this.testsTreeViewer != null) {
            this.testsTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.testsTreeViewer.removeDoubleClickListener((IDoubleClickListener)this);
            this.testsTreeViewer = null;
        }
        this.testSuite = null;
        this.typeValidator = null;
        if (this.loadedEObjects != null) {
            Iterator i = this.loadedEObjects.iterator();
            while (i.hasNext()) {
                ((EObject)i.next()).eResource().unload();
            }
            this.loadedEObjects.clear();
            this.loadedEObjects = null;
        }
        System.gc();
    }

    public void setTest(ITest test) {
        this.tests.clear();
        this.tests.add(test);
        this.selectTest(this.tests);
    }

    public Collection getTests() {
        return this.tests;
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    protected ITypeValidator getTypeValidator() {
        return this.typeValidator;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        this.localTestCasesTableViewer.setInput((Object)this.testSuite);
        if (this.testsTreeViewer != null) {
            this.testsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        this.selectTest(this.getTests());
        this.registerHelp(1, control);
        this.registerHelp(2, this.localTestCasesTableViewer.getControl());
        if (this.testsTreeViewer != null) {
            this.registerHelp(3, this.testsTreeViewer.getControl());
        }
        return control;
    }

    protected void registerHelp(int flag, Object object) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        superComposite.setLayoutData((Object)gridData);
        this.createLocalTestCasesControl(superComposite);
        if (this.getTypeValidator() != null) {
            this.createTestControl(superComposite);
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        return superComposite;
    }

    protected void selectTest(Collection tests) {
        if (this.localTestCasesTableViewer == null) {
            return;
        }
        if (tests != null) {
            for (ITest test : tests) {
                if (test instanceof ITestCase && ((ITestCase)test).getOwner() == this.testSuite) {
                    this.localTestCasesTableViewer.setSelection((ISelection)new StructuredSelection((Object)test), true);
                    continue;
                }
                if (this.testsTreeViewer == null) continue;
                test = (ITest)EMFUtil.getEObject((ResourceSet)this.testsResourceSet, (EObject)((EObject)test), (boolean)true);
                this.testsTreeViewer.setSelection((ISelection)new StructuredSelection((Object)test), true);
            }
        } else {
            this.localTestCasesTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            if (this.testsTreeViewer != null) {
                this.testsTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    protected void createLocalTestCasesControl(Composite parent) {
        if (this.tableLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.tableLabel);
        }
        int selection = this.singleSelection ? 4 : 2;
        this.localTestCasesTableViewer = new TableViewer(parent, selection | 0x100 | 0x200 | 0x800);
        this.localTestCasesTableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.localTestCasesTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.getTypeValidator() != null) {
            GridData gridData = GridDataUtil.createHorizontalFill();
            gridData.grabExcessVerticalSpace = false;
            gridData.heightHint = 100;
            this.localTestCasesTableViewer.getControl().setLayoutData((Object)gridData);
        } else {
            this.localTestCasesTableViewer.getControl().setLayoutData((Object)GridDataUtil.createFill());
        }
        IStructuredContentProvider tableViewContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (OldInvokedTestSelectionDialog.this.getTestSuite() != null) {
                    return OldInvokedTestSelectionDialog.this.getTestSuite().getITestCases().toArray();
                }
                return new Object[0];
            }
        };
        this.localTestCasesTableViewer.setContentProvider((IContentProvider)tableViewContentProvider);
        this.localTestCasesTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class));
    }

    protected void createTestControl(Composite parent) {
        if (this.treeLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.treeLabel);
        }
        int selection = this.singleSelection ? 4 : 2;
        this.testsTreeViewer = new TreeViewer(parent, selection | 0x100 | 0x200 | 0x800);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 220;
        this.testsTreeViewer.getControl().setLayoutData((Object)gridData);
        this.testsTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.testsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ITest) {
                    ITest test = (ITest)element;
                    if (OldInvokedTestSelectionDialog.this.getTestSuite().getId().equals(test.getId())) {
                        return false;
                    }
                    return OldInvokedTestSelectionDialog.this.getTypeValidator().isValidType(test.getType());
                }
                return true;
            }
        };
        this.testsTreeViewer.addFilter(viewerFilter);
        this.testsResourceSet = new ResourceSetImpl();
        EMFContentProvider modelContentProvider = new EMFContentProvider(this.testsResourceSet);
        EMFContentProvider.ElementDescription elementDescription = new EMFContentProvider.ElementDescription("testsuite");
        elementDescription.getEClassifiers().add(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        modelContentProvider.addElementDescription(elementDescription);
        EMFContentProvider.EnabledChildren enabledChildren = new EMFContentProvider.EnabledChildren((EClassifier)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        enabledChildren.getChildrenEStructuralFeatures().add(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases());
        modelContentProvider.addEnabledChildren(enabledChildren);
        this.testsTreeViewer.setContentProvider((IContentProvider)modelContentProvider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.testsTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class), decorator));
        modelContentProvider.setShowEnabledChildren(true);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.processSelection((IStructuredSelection)event.getSelection())) {
            this.okPressed();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.processSelection((IStructuredSelection)event.getSelection());
    }

    protected boolean processSelection(IStructuredSelection structuredSelection) {
        if (!structuredSelection.isEmpty()) {
            ArrayList selectedTests = new ArrayList();
            for (Object object : structuredSelection) {
                if (!(object instanceof ITest)) continue;
                selectedTests.add(object);
            }
            if (!selectedTests.isEmpty()) {
                this.tests = selectedTests;
                this.getButton(0).setEnabled(true);
                return true;
            }
        }
        this.getButton(0).setEnabled(false);
        return false;
    }

    protected void buttonPressed(int buttonId) {
        IContentProvider contentProvider;
        this.setWaitCursor();
        if (this.testsTreeViewer != null && (contentProvider = this.testsTreeViewer.getContentProvider()) instanceof EMFContentProvider) {
            this.loadedEObjects = ((EMFContentProvider)contentProvider).getLoadedEObjects();
        }
        if (buttonId == 0 && this.loadedEObjects != null && !this.loadedEObjects.isEmpty()) {
            Iterator testIterator = this.tests.iterator();
            block0: while (testIterator.hasNext()) {
                if (this.loadedEObjects.isEmpty()) break;
                ITest test = (ITest)testIterator.next();
                if (!(test instanceof EObject)) continue;
                for (EObject eObj : this.loadedEObjects) {
                    if (test != eObj && ((EObject)test).eContainer() != eObj) continue;
                    this.loadedEObjects.remove(eObj);
                    continue block0;
                }
            }
        }
        this.dispose();
        this.unsetWaitCursor();
        super.buttonPressed(buttonId);
    }

    private void setWaitCursor() {
        Display display = this.getShell().getDisplay();
        Cursor waitCursor = new Cursor((Device)display, 1);
        this.getShell().setCursor(waitCursor);
    }

    private void unsetWaitCursor() {
        this.getShell().setCursor(null);
    }
}

